/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.YesNoCancelDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Frame;

public class ImageCalculator
implements PlugIn {
    private static int operator;
    private static String title1;
    private static String title2;
    private static boolean createWindow;
    static /* synthetic */ Class class$ij$plugin$ImageCalculator;

    public void run(String arg) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No windows are open.");
            return;
        }
        IJ.register(class$ij$plugin$ImageCalculator == null ? (class$ij$plugin$ImageCalculator = ImageCalculator.class$("ij.plugin.ImageCalculator")) : class$ij$plugin$ImageCalculator);
        String[] titles = new String[wList.length];
        String[] operators = new String[]{"Add", "Subtract", "Multiply", "Divide", "AND", "OR", "XOR", "Min", "Max", "Average", "Difference", "Copy"};
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
            ++i;
        }
        GenericDialog gd = new GenericDialog("Image Calculator", IJ.getInstance());
        String defaultItem = title1.equals("") ? titles[0] : title1;
        gd.addChoice("Image1:", titles, defaultItem);
        gd.addChoice("Operation:", operators, operators[operator]);
        defaultItem = title2.equals("") ? titles[0] : title2;
        gd.addChoice("Image2:", titles, defaultItem);
        gd.addCheckbox("Create New Window", createWindow);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int index1 = gd.getNextChoiceIndex();
        title1 = titles[index1];
        operator = gd.getNextChoiceIndex();
        int index2 = gd.getNextChoiceIndex();
        createWindow = gd.getNextBoolean();
        title2 = titles[index2];
        ImagePlus img1 = WindowManager.getImage(wList[index1]);
        ImagePlus img2 = WindowManager.getImage(wList[index2]);
        int size1 = img1.getStackSize();
        int size2 = img2.getStackSize();
        if (size1 > 1 && size2 > 1 && size1 != size2) {
            IJ.showMessage("Image Calculator", "Both stacks must have the same number of sizes.");
            return;
        }
        if (size1 > 1 && (size2 == 1 || size1 == size2)) {
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Process Stack?", "Process all " + size1 + " slices?");
            if (d.cancelPressed()) {
                return;
            }
            if (d.yesPressed()) {
                this.doStackOperation(img1, img2);
            } else {
                this.doOperation(img1, img2);
            }
        } else {
            this.doOperation(img1, img2);
        }
    }

    void doStackOperation(ImagePlus img1, ImagePlus img2) {
        if (createWindow) {
            if ((img1 = this.duplicateStack(img1)) == null) {
                IJ.showMessage("Calculator", "Out of memory");
                return;
            }
            img1.show();
        }
        int mode = this.getBlitterMode();
        ImageWindow win = img1.getWindow();
        if (win != null) {
            WindowManager.setCurrentWindow(win);
        }
        Undo.reset();
        ImageStack stack1 = img1.getStack();
        StackProcessor sp = new StackProcessor(stack1, img1.getProcessor());
        try {
            if (img2.getStackSize() == 1) {
                sp.copyBits(img2.getProcessor(), 0, 0, mode);
            } else {
                sp.copyBits(img2.getStack(), 0, 0, mode);
            }
        }
        catch (IllegalArgumentException e) {
            IJ.error("\"" + img1.getTitle() + "\": " + e.getMessage());
            return;
        }
        img1.setStack(null, stack1);
        img1.updateAndDraw();
    }

    void doOperation(ImagePlus img1, ImagePlus img2) {
        int mode = this.getBlitterMode();
        ImageProcessor ip1 = img1.getProcessor();
        ImageProcessor ip2 = img2.getProcessor();
        if (createWindow) {
            ip1 = this.createNewImage(ip1, ip2);
        } else {
            ImageWindow win = img1.getWindow();
            if (win != null) {
                WindowManager.setCurrentWindow(win);
            }
            ip1.snapshot();
            Undo.setup(1, img1);
        }
        try {
            ip1.copyBits(ip2, 0, 0, mode);
        }
        catch (IllegalArgumentException e) {
            IJ.error("\"" + img1.getTitle() + "\": " + e.getMessage());
            return;
        }
        if (createWindow) {
            new ImagePlus("Result", ip1).show();
        } else {
            img1.updateAndDraw();
        }
    }

    ImageProcessor createNewImage(ImageProcessor ip1, ImageProcessor ip2) {
        int width = Math.min(ip1.getWidth(), ip2.getWidth());
        int height = Math.min(ip1.getHeight(), ip2.getHeight());
        ImageProcessor ip3 = ip1.createProcessor(width, height);
        ip3.insert(ip1, 0, 0);
        return ip3;
    }

    private int getBlitterMode() {
        int mode = 0;
        switch (operator) {
            case 0: {
                mode = 3;
                break;
            }
            case 1: {
                mode = 4;
                break;
            }
            case 2: {
                mode = 5;
                break;
            }
            case 3: {
                mode = 6;
                break;
            }
            case 4: {
                mode = 9;
                break;
            }
            case 5: {
                mode = 10;
                break;
            }
            case 6: {
                mode = 11;
                break;
            }
            case 7: {
                mode = 12;
                break;
            }
            case 8: {
                mode = 13;
                break;
            }
            case 9: {
                mode = 7;
                break;
            }
            case 10: {
                mode = 8;
                break;
            }
            case 11: {
                mode = 0;
            }
        }
        return mode;
    }

    ImagePlus duplicateStack(ImagePlus img1) {
        ImageStack stack1 = img1.getStack();
        int width = stack1.getWidth();
        int height = stack1.getHeight();
        int n = stack1.getSize();
        ImageStack stack2 = img1.createEmptyStack();
        try {
            int i = 1;
            while (i <= n) {
                ImageProcessor ip1 = stack1.getProcessor(i);
                ip1.setRoi(null);
                ImageProcessor ip2 = ip1.crop();
                stack2.addSlice(stack1.getSliceLabel(i), ip2);
                ++i;
            }
        }
        catch (OutOfMemoryError e) {
            stack2.trim();
            stack2 = null;
            return null;
        }
        return new ImagePlus("Result", stack2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        title1 = "";
        title2 = "";
        createWindow = true;
    }
}

