/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.io.File;

public class FolderOpener
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open All As Stack...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String[] list = new File(directory).list();
        if (list == null) {
            return;
        }
        StringSorter.sort(list);
        if (IJ.debugMode) {
            IJ.write("FolderOpener: " + directory + " (" + list.length + " files)");
        }
        int width = 0;
        int height = 0;
        int type = 0;
        ImageStack stack = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int n = 0;
        try {
            int i = 0;
            while (i < list.length) {
                ImagePlus imp = new Opener().openImage(directory, list[i]);
                if (imp != null && stack == null) {
                    stack = imp.createEmptyStack();
                    width = imp.getWidth();
                    height = imp.getHeight();
                    type = imp.getType();
                }
                if (stack != null) {
                    n = stack.getSize() + 1;
                }
                IJ.showStatus(n + "/" + list.length);
                IJ.showProgress((double)n / (double)list.length);
                if (imp == null) {
                    IJ.write(list[i] + ": unable to open");
                } else if (imp.getWidth() != width || imp.getHeight() != height) {
                    IJ.write(list[i] + ": wrong dimensions");
                } else if (imp.getType() != type) {
                    IJ.write(list[i] + ": wrong type");
                } else {
                    ImageProcessor ip = imp.getProcessor();
                    if (ip.getMin() < min) {
                        min = ip.getMin();
                    }
                    if (ip.getMax() > max) {
                        max = ip.getMax();
                    }
                    stack.addSlice(imp.getTitle(), ip);
                }
                System.gc();
                ++i;
            }
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory("FolderOpener");
            stack.trim();
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus("Stack", stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.show();
        }
        IJ.showProgress(1.0);
    }
}

