/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import ij.plugin.DicomDictionary;
import ij.util.Tools;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

class DicomDecoder {
    private static final int PIXEL_REPRESENTATION = 2621699;
    private static final int TRANSFER_SYNTAX_UID = 131088;
    private static final int SLICE_SPACING = 0x180088;
    private static final int NUMBER_OF_FRAMES = 0x280008;
    private static final int ROWS = 2621456;
    private static final int COLUMNS = 2621457;
    private static final int PIXEL_SPACING = 2621488;
    private static final int BITS_ALLOCATED = 2621696;
    private static final int RED_PALETTE = 2626049;
    private static final int GREEN_PALETTE = 2626050;
    private static final int BLUE_PALETTE = 2626051;
    private static final int PIXEL_DATA = 2145386512;
    private static final int AE = 16709;
    private static final int AS = 16723;
    private static final int AT = 16724;
    private static final int CS = 17235;
    private static final int DA = 17473;
    private static final int DS = 17491;
    private static final int DT = 17492;
    private static final int FD = 17988;
    private static final int FL = 17996;
    private static final int IS = 18771;
    private static final int LO = 19535;
    private static final int LT = 19540;
    private static final int PN = 20558;
    private static final int SH = 21320;
    private static final int SL = 21324;
    private static final int SS = 21331;
    private static final int ST = 21332;
    private static final int TM = 21581;
    private static final int UI = 21833;
    private static final int UL = 21836;
    private static final int US = 21843;
    private static final int UT = 21844;
    private static final int OB = 20290;
    private static final int OW = 20311;
    private static final int SQ = 21329;
    private static final int UN = 21838;
    private static final int QQ = 16191;
    private static Properties dictionary;
    private String directory;
    private String fileName;
    private static final int ID_OFFSET = 128;
    private static final String DICM = "DICM";
    private BufferedInputStream f;
    private int location = 0;
    private boolean littleEndian = true;
    private int elementLength;
    private int vr;
    private static final int IMPLICIT_VR = 11565;
    private byte[] vrLetters = new byte[2];
    private int previousGroup;
    private StringBuffer dicomInfo = new StringBuffer(1000);
    private boolean dicmFound;
    private boolean oddLocations;
    static char[] buf8;
    char[] buf10;
    static /* synthetic */ Class class$ij$plugin$DICOM;

    public DicomDecoder(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        if (dictionary == null) {
            DicomDictionary d = new DicomDictionary();
            dictionary = d.getDictionary();
        }
        IJ.register(class$ij$plugin$DICOM == null ? (class$ij$plugin$DICOM = DicomDecoder.class$("ij.plugin.DICOM")) : class$ij$plugin$DICOM);
    }

    String getString(int length) throws IOException {
        byte[] buf = new byte[length];
        int pos = 0;
        while (pos < length) {
            int count = this.f.read(buf, pos, length - pos);
            pos += count;
        }
        this.location += length;
        return new String(buf);
    }

    int getByte() throws IOException {
        int b = this.f.read();
        if (b == -1) {
            throw new IOException("unexpected EOF");
        }
        ++this.location;
        return b;
    }

    int getShort() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        if (this.littleEndian) {
            return (b1 << 8) + b0;
        }
        return (b0 << 8) + b1;
    }

    final int getInt() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    byte[] getLut(int length) throws IOException {
        if ((length & 1) != 0) {
            String dummy = this.getString(length);
            return null;
        }
        byte[] lut = new byte[length /= 2];
        int i = 0;
        while (i < length) {
            lut[i] = (byte)(this.getShort() >>> 8);
            ++i;
        }
        return lut;
    }

    int getLength() throws IOException {
        int b0 = this.getByte();
        int b1 = this.getByte();
        int b2 = this.getByte();
        int b3 = this.getByte();
        this.vr = (b0 << 8) + b1;
        switch (this.vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (b2 == 0 || b3 == 0) {
                    return this.getInt();
                }
                this.vr = 11565;
                if (this.littleEndian) {
                    return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
                }
                return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                if (this.littleEndian) {
                    return (b3 << 8) + b2;
                }
                return (b2 << 8) + b3;
            }
        }
        this.vr = 11565;
        if (this.littleEndian) {
            return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
        }
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    int getNextTag() throws IOException {
        int groupWord = this.getShort();
        int elementWord = this.getShort();
        int tag = groupWord << 16 | elementWord;
        this.elementLength = this.getLength();
        if (this.elementLength == 13 && !this.oddLocations) {
            this.elementLength = 10;
        }
        if (this.elementLength == -1) {
            this.elementLength = 0;
        }
        return tag;
    }

    FileInfo getFileInfo() throws IOException {
        FileInfo fi = new FileInfo();
        int bitsAllocated = 16;
        fi.fileFormat = 1;
        fi.fileName = this.fileName;
        fi.directory = this.directory;
        fi.width = 0;
        fi.height = 0;
        fi.offset = 0;
        fi.intelByteOrder = true;
        fi.fileType = 2;
        this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
        if (IJ.debugMode) {
            IJ.write("");
            IJ.write("DicomDecoder: decoding " + this.fileName);
        }
        long skipCount = 128L;
        while (skipCount > 0L) {
            skipCount -= this.f.skip(skipCount);
        }
        this.location += 128;
        if (!this.getString(4).equals(DICM)) {
            this.f.close();
            this.f = new BufferedInputStream(new FileInputStream(this.directory + this.fileName));
            this.location = 0;
            if (IJ.debugMode) {
                IJ.write("DICM not found at offset 128; reseting to offset 0");
            }
        } else if (IJ.debugMode) {
            this.dicmFound = true;
            IJ.write("DICM found at offset 128");
        }
        boolean inSequence = true;
        while (true) {
            int tag = this.getNextTag();
            if ((this.location & 1) != 0) {
                this.oddLocations = true;
                if (this.dicmFound) break;
            }
            if (tag == 131088) {
                String s = this.getString(this.elementLength);
                this.addInfo(tag, s);
                if (s.indexOf("1.2.4") <= -1 && s.indexOf("1.2.5") <= -1) continue;
                this.f.close();
                String msg = "ImageJ cannot open compressed DICOM images.\n \n";
                msg = msg + "Transfer Syntax UID = " + s;
                throw new IOException(msg);
            }
            if (tag == 0x280008) {
                String s = this.getString(this.elementLength);
                this.addInfo(tag, s);
                double frames = this.s2d(s);
                if (!(frames > 1.0)) continue;
                fi.nImages = (int)frames;
                continue;
            }
            if (tag == 2621456) {
                fi.height = this.getShort();
                this.addInfo(tag, Integer.toString(fi.height));
                continue;
            }
            if (tag == 2621457) {
                fi.width = this.getShort();
                this.addInfo(tag, Integer.toString(fi.width));
                continue;
            }
            if (tag == 2621488) {
                String scale = this.getString(this.elementLength);
                this.getSpatialScale(fi, scale);
                this.addInfo(tag, scale);
                continue;
            }
            if (tag == 0x180088) {
                String spacing = this.getString(this.elementLength);
                fi.pixelDepth = this.s2d(spacing);
                this.addInfo(tag, spacing);
                continue;
            }
            if (tag == 2621696) {
                bitsAllocated = this.getShort();
                if (bitsAllocated == 8) {
                    fi.fileType = 0;
                }
                this.addInfo(tag, Integer.toString(bitsAllocated));
                continue;
            }
            if (tag == 2621699) {
                int pixelRepresentation = this.getShort();
                if (pixelRepresentation == 1) {
                    fi.fileType = 1;
                }
                this.addInfo(tag, Integer.toString(pixelRepresentation));
                continue;
            }
            if (tag == 2626049) {
                fi.reds = this.getLut(this.elementLength);
                this.addInfo(tag, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (tag == 2626050) {
                fi.greens = this.getLut(this.elementLength);
                this.addInfo(tag, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (tag == 2626051) {
                fi.blues = this.getLut(this.elementLength);
                this.addInfo(tag, Integer.toString(this.elementLength / 2));
                continue;
            }
            if (tag == 2145386512 && this.elementLength != 0) {
                fi.offset = this.location;
                this.addInfo(tag, Integer.toString(this.location));
                break;
            }
            if (tag == 2139619344 && this.elementLength != 0) {
                fi.offset = this.location + 4;
                break;
            }
            this.addInfo(tag, null);
        }
        if (fi.fileType == 0 && fi.reds != null && fi.greens != null && fi.blues != null && fi.reds.length == fi.greens.length && fi.reds.length == fi.blues.length) {
            fi.fileType = 5;
            fi.lutSize = fi.reds.length;
        }
        if (IJ.debugMode) {
            IJ.write("width: " + fi.width);
            IJ.write("height: " + fi.height);
            IJ.write("images: " + fi.nImages);
            IJ.write("bits allocated: " + bitsAllocated);
            IJ.write("offset: " + fi.offset);
        }
        this.f.close();
        return fi;
    }

    String getDicomInfo() {
        return new String(this.dicomInfo);
    }

    void addInfo(int tag, String value) throws IOException {
        String info = this.getHeaderInfo(tag, value);
        if (info != null) {
            int group = tag >>> 16;
            if (group != this.previousGroup) {
                this.dicomInfo.append("\n");
            }
            this.previousGroup = group;
            this.dicomInfo.append(this.tag2hex(tag) + info + "\n");
        }
        if (IJ.debugMode) {
            if (info == null) {
                info = "";
            }
            this.vrLetters[0] = (byte)(this.vr >> 8);
            this.vrLetters[1] = (byte)(this.vr & 0xFF);
            String VR = new String(this.vrLetters);
            IJ.write("(" + this.tag2hex(tag) + VR + " " + this.elementLength + " bytes from " + (this.location - this.elementLength) + ") " + info);
        }
    }

    String getHeaderInfo(int tag, String value) throws IOException {
        String key = this.i2hex(tag);
        String id = (String)((Hashtable)dictionary).get(key);
        if (id != null) {
            if (this.vr == 11565 && id != null) {
                this.vr = (id.charAt(0) << 8) + id.charAt(1);
            }
            id = id.substring(2);
        }
        if (value != null) {
            return id + ": " + value;
        }
        switch (this.vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                value = this.getString(this.elementLength);
                break;
            }
            case 21843: {
                if (this.elementLength == 2) {
                    value = Integer.toString(this.getShort());
                    break;
                }
                value = "";
                int n = this.elementLength / 2;
                int i = 0;
                while (i < n) {
                    value = value + Integer.toString(this.getShort()) + " ";
                    ++i;
                }
                break;
            }
            default: {
                long skipCount = this.elementLength;
                while (skipCount > 0L) {
                    skipCount -= this.f.skip(skipCount);
                }
                this.location += this.elementLength;
                value = "";
            }
        }
        if (id == null) {
            return null;
        }
        return id + ": " + value;
    }

    String i2hex(int i) {
        int pos = 7;
        while (pos >= 0) {
            DicomDecoder.buf8[pos] = Tools.hexDigits[i & 0xF];
            i >>>= 4;
            --pos;
        }
        return new String(buf8);
    }

    String tag2hex(int tag) {
        if (this.buf10 == null) {
            this.buf10 = new char[11];
            this.buf10[4] = 44;
            this.buf10[9] = 32;
        }
        int pos = 8;
        while (pos >= 0) {
            this.buf10[pos] = Tools.hexDigits[tag & 0xF];
            tag >>>= 4;
            if (--pos != 4) continue;
            --pos;
        }
        return new String(this.buf10);
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void getSpatialScale(FileInfo fi, String scale) {
        double xscale = 0.0;
        double yscale = 0.0;
        int i = scale.indexOf(92);
        if (i > 0) {
            xscale = this.s2d(scale.substring(0, i));
            yscale = this.s2d(scale.substring(i + 1));
        }
        if (xscale != 0.0 && yscale != 0.0) {
            fi.pixelWidth = xscale;
            fi.pixelHeight = yscale;
            fi.unit = "mm";
        }
    }

    boolean dicmFound() {
        return this.dicmFound;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        buf8 = new char[8];
    }
}

