/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.DicomDecoder;
import ij.plugin.PlugIn;
import java.io.IOException;

public class DICOM
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        FileInfo fi;
        DicomDecoder dd;
        String fileName;
        block10: {
            OpenDialog od = new OpenDialog("Open Dicom...", arg);
            String directory = od.getDirectory();
            fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            IJ.showStatus("Opening: " + directory + fileName);
            dd = new DicomDecoder(directory, fileName);
            fi = null;
            try {
                fi = dd.getFileInfo();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                IJ.showStatus("");
                if (msg.indexOf("EOF") < 0) {
                    IJ.showMessage("DicomDecoder", msg);
                    return;
                }
                if (dd.dicmFound()) break block10;
                msg = "This does not appear to be a valid\nDICOM file. It does not have the\ncharacters 'DICM' at offset 128.";
                IJ.showMessage("DicomDecoder", msg);
                return;
            }
        }
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            if (fi.fileType == 1) {
                Calibration cal = imp.getCalibration();
                double[] coeff = new double[]{-32768.0, 1.0};
                cal.setFunction(0, coeff, "gray value");
            }
            if (imp.getStackSize() > 1) {
                this.setStack(fileName, imp.getStack());
            } else {
                this.setProcessor(fileName, imp.getProcessor());
            }
            this.setCalibration(imp.getCalibration());
            this.setProperty("Info", dd.getDicomInfo());
            if (arg.equals("")) {
                this.show();
            }
        } else {
            IJ.showMessage("DicomDecoder", "Unable to decode DICOM header.");
        }
        IJ.showStatus("");
    }
}

