/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.ImageReader;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.plugin.frame.Editor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.text.TextWindow;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Opener {
    private static final int UNKNOWN = 0;
    private static final int TIFF = 1;
    private static final int DICOM = 2;
    private static final int FITS = 3;
    private static final int PGM = 4;
    private static final int JPEG = 5;
    private static final int GIF = 6;
    private static final int LUT = 7;
    private static final int BMP = 8;
    private static final int ZIP = 9;
    private static final int JAVA = 10;
    private static final int ROI = 11;
    private static final int TEXT = 12;
    private static String defaultDirectory = null;
    private boolean showErrorDialog = false;

    public void openImage() {
        OpenDialog od = new OpenDialog("Open...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + name);
        this.showErrorDialog = true;
        ImagePlus imp = this.openImage(directory, name);
        if (imp != null) {
            imp.show();
        }
    }

    public ImagePlus openImage(String directory, String name) {
        String path = directory + name;
        switch (this.getFileType(path, name)) {
            case 1: {
                ImagePlus imp = this.openTiff(directory, name);
                return imp;
            }
            case 2: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.DICOM", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 3: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.FITS", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 4: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.PGM_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 5: 
            case 6: {
                ImagePlus imp = this.openJpegOrGif(directory, name);
                if (imp != null && imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 7: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.LutLoader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 8: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.BMP", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 9: {
                ImagePlus imp = (ImagePlus)IJ.runPlugIn("ij.plugin.Zip_Reader", path);
                if (imp.getWidth() != 0) {
                    return imp;
                }
                return null;
            }
            case 11: {
                IJ.runPlugIn("ij.plugin.RoiReader", path);
                return null;
            }
            case 10: 
            case 12: {
                File file = new File(path);
                if (file.length() < 28000L) {
                    Editor ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
                    if (ed != null) {
                        ed.open(directory, name);
                    }
                } else {
                    new TextWindow(path, 400, 450);
                }
                return null;
            }
            case 0: {
                if (this.showErrorDialog) {
                    IJ.showMessage("Open...", "This file does not appear to be in TIFF, JPEG, \n GIF, BMP, DICOM, FITS, PGM, ZIP or LUT format.");
                }
                return null;
            }
        }
        return null;
    }

    public ImagePlus openURL(String url) {
        try {
            String name = "";
            int index = url.lastIndexOf(47);
            if (index == -1) {
                index = url.lastIndexOf(92);
            }
            if (index <= 0) {
                throw new MalformedURLException("Invalid URL: " + url);
            }
            name = url.substring(index + 1);
            URL u = new URL(url);
            IJ.showStatus("" + url);
            ImagePlus imp = null;
            imp = url.endsWith(".tif") || url.endsWith(".TIF") ? this.openTiff(u.openStream(), name) : (url.endsWith(".zip") ? this.openZip(u) : this.openJpegOrGifUsingURL(name, u));
            IJ.showStatus("");
            return imp;
        }
        catch (Exception e) {
            IJ.showMessage("" + e);
            return null;
        }
    }

    ImagePlus openZip(URL url) throws IOException {
        int len;
        IJ.showProgress(0.01);
        URLConnection uc = url.openConnection();
        int fileSize = uc.getContentLength();
        fileSize *= 2;
        InputStream in = uc.getInputStream();
        ZipInputStream zin = new ZipInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        ZipEntry entry = zin.getNextEntry();
        if (entry == null) {
            return null;
        }
        String name = entry.getName();
        if (!name.endsWith(".tif")) {
            throw new IOException("This ZIP archive does not appear to contain a TIFF file");
        }
        int byteCount = 0;
        boolean progress = false;
        while ((len = zin.read(buf)) >= 0) {
            out.write(buf, 0, len);
            IJ.showProgress((double)((byteCount += len) % fileSize) / (double)fileSize);
        }
        zin.close();
        byte[] bytes = out.toByteArray();
        IJ.showProgress(1.0);
        return this.openTiff(new ByteArrayInputStream(bytes), name);
    }

    ImagePlus openJpegOrGifUsingURL(String title, URL url) {
        if (url == null) {
            return null;
        }
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        if (img != null) {
            ImagePlus imp = new ImagePlus(title, img);
            return imp;
        }
        return null;
    }

    ImagePlus openJpegOrGif(String dir, String name) {
        ImagePlus imp = null;
        Image img = Toolkit.getDefaultToolkit().getImage(dir + name);
        if (img != null) {
            imp = new ImagePlus(name, img);
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            FileInfo fi = new FileInfo();
            fi.fileFormat = 3;
            fi.fileName = name;
            fi.directory = dir;
            imp.setFileInfo(fi);
        }
        return imp;
    }

    public static void convertGrayJpegTo8Bits(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int width = ip.getWidth();
        int height = ip.getHeight();
        int[] pixels = (int[])ip.getPixels();
        int y = 0;
        while (y < height - 8) {
            int offset = y * width;
            int x = 0;
            while (x < width - 8) {
                int c = pixels[offset + x];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                if (r != g || g != b) {
                    return;
                }
                ++x;
            }
            ++y;
        }
        IJ.showStatus("Converting to 8-bits");
        new ImageConverter(imp).convertToGray8();
    }

    boolean allSameSizeAndType(FileInfo[] info) {
        boolean sameSizeAndType = true;
        boolean contiguous = true;
        int startingOffset = info[0].offset;
        int size = info[0].width * info[0].height * info[0].getBytesPerPixel();
        int i = 1;
        while (i < info.length) {
            sameSizeAndType &= info[i].fileType == info[0].fileType && info[i].width == info[0].width && info[i].height == info[0].height;
            contiguous &= info[i].offset == startingOffset + i * size;
            ++i;
        }
        if (contiguous) {
            info[0].nImages = info.length;
        }
        if (IJ.debugMode) {
            IJ.write("  sameSizeAndType: " + sameSizeAndType);
            IJ.write("  contiguous: " + contiguous);
        }
        return sameSizeAndType;
    }

    public ImagePlus openTiffStack(FileInfo[] info) {
        if (info.length > 1 && !this.allSameSizeAndType(info)) {
            return null;
        }
        FileInfo fi = info[0];
        if (fi.nImages > 1) {
            return new FileOpener(fi).open(false);
        }
        ColorModel cm = FileOpener.createColorModel(fi);
        ImageStack stack = new ImageStack(fi.width, fi.height, cm);
        int skip = fi.offset;
        int imageSize = fi.width * fi.height * fi.getBytesPerPixel();
        int loc = 0;
        try {
            InputStream is = FileOpener.createInputStream(fi);
            ImageReader reader = new ImageReader(fi);
            int i = 0;
            while (i < info.length) {
                IJ.showStatus("Reading: " + (i + 1) + "/" + info.length);
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                if (i < info.length - 1 && (skip = info[i + 1].offset - (loc += imageSize + skip)) < 0) {
                    throw new IOException("Images are not in order");
                }
                if (fi.fileType == 2) {
                    stack.addUnsignedShortSlice(null, pixels);
                } else {
                    stack.addSlice(null, pixels);
                }
                IJ.showProgress((double)i / (double)info.length);
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            IJ.write("" + e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(fi.fileName);
            stack.deleteLastSlice();
            stack.deleteLastSlice();
        }
        IJ.showProgress(1.0);
        if (stack.getSize() == 0) {
            return null;
        }
        if (fi.whiteIsZero) {
            new StackProcessor(stack, stack.getProcessor(1)).invert();
        }
        ImagePlus imp = new ImagePlus(fi.fileName, stack);
        FileOpener.setResolution(fi, imp);
        imp.setFileInfo(fi);
        IJ.showProgress(1.0);
        return imp;
    }

    public ImagePlus openTiff(String directory, String name) {
        TiffDecoder td = new TiffDecoder(directory, name);
        if (IJ.debugMode) {
            td.enableDebugging();
        }
        FileInfo[] info = null;
        try {
            info = td.getTiffInfo();
        }
        catch (IOException e) {
            IJ.showMessage("TiffDecoder", e.getMessage());
            return null;
        }
        if (info == null) {
            return null;
        }
        return this.openTiff2(info);
    }

    public ImagePlus openTiff(InputStream in, String name) {
        FileInfo[] info = null;
        try {
            TiffDecoder td = new TiffDecoder(in, name);
            if (IJ.debugMode) {
                td.enableDebugging();
            }
            info = td.getTiffInfo();
        }
        catch (FileNotFoundException e) {
            IJ.showMessage("TiffDecoder", "File not found: " + e.getMessage());
            return null;
        }
        catch (Exception e) {
            IJ.showMessage("TiffDecoder", "" + e);
            return null;
        }
        return this.openTiff2(info);
    }

    ImagePlus openTiff2(FileInfo[] info) {
        if (info == null) {
            return null;
        }
        ImagePlus imp = null;
        if (IJ.debugMode) {
            IJ.write(info[0].info);
        }
        if (info.length > 1 && (imp = this.openTiffStack(info)) != null) {
            return imp;
        }
        FileOpener fo = new FileOpener(info[0]);
        imp = fo.open(false);
        IJ.showStatus("");
        return imp;
    }

    int getFileType(String path, String name) {
        byte[] buf = new byte[132];
        try {
            FileInputStream is = new FileInputStream(path);
            ((InputStream)is).read(buf, 0, 132);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            return 0;
        }
        int b0 = buf[0] & 0xFF;
        int b1 = buf[1] & 0xFF;
        int b2 = buf[2] & 0xFF;
        int b3 = buf[3] & 0xFF;
        if (b0 == 73 && b1 == 73 && b2 == 42 && b3 == 0) {
            return 1;
        }
        if (b0 == 77 && b1 == 77 && b2 == 0 && b3 == 42) {
            return 1;
        }
        if (b0 == 255 && b1 == 216 && b2 == 255) {
            return 5;
        }
        if (b0 == 71 && b1 == 73 && b2 == 70 && b3 == 56) {
            return 6;
        }
        if (buf[128] == 68 && buf[129] == 73 && buf[130] == 67 && buf[131] == 77) {
            return 2;
        }
        if (b0 == 8 && b1 == 0 && b3 == 0) {
            return 2;
        }
        if (b0 == 83 && b1 == 73 && b2 == 77 && b3 == 80) {
            return 3;
        }
        if (!(b0 != 80 || b1 != 50 && b1 != 53 || b2 != 10 && b2 != 13 && b2 != 32 && b2 != 9)) {
            return 4;
        }
        if ((name = name.toLowerCase()).endsWith(".lut")) {
            return 7;
        }
        if (b0 == 66 && b1 == 77 && name.endsWith(".bmp")) {
            return 8;
        }
        if (name.endsWith(".zip")) {
            return 9;
        }
        if (name.endsWith(".java")) {
            return 10;
        }
        if (b0 == 73 && b1 == 111) {
            return 11;
        }
        if (name.endsWith(".txt") || b0 >= 32 && b0 <= 126 && b1 >= 32 && b1 <= 126 && b2 >= 32 && b2 <= 126 && b3 >= 32 && b3 <= 126 && buf[8] >= 32 && buf[8] <= 126) {
            return 12;
        }
        return 0;
    }
}

