/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.Prefs;
import ij.io.DCT;
import ij.io.Huffman;
import ij.io.JpegInfo;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder
extends Frame {
    Thread runner;
    BufferedOutputStream outStream;
    Image image;
    JpegInfo JpegObj;
    Huffman Huf;
    DCT dct;
    int imageHeight;
    int imageWidth;
    static int Quality;
    static int defaultQuality;
    int code;
    public static int[] jpegNaturalOrder;

    public JpegEncoder(Image image, int quality, OutputStream out) {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Quality = quality;
        this.JpegObj = new JpegInfo(image);
        this.imageHeight = this.JpegObj.imageHeight;
        this.imageWidth = this.JpegObj.imageWidth;
        this.outStream = new BufferedOutputStream(out);
        this.dct = new DCT(Quality);
        this.Huf = new Huffman(this.imageWidth, this.imageHeight);
    }

    public static void setQuality(int quality) {
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 100) {
            quality = 100;
        }
        Quality = quality;
    }

    public static int getQuality() {
        return Quality;
    }

    public void Compress() {
        this.WriteHeaders(this.outStream);
        this.WriteCompressedData(this.outStream);
        this.WriteEOI(this.outStream);
        try {
            this.outStream.flush();
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    public void WriteCompressedData(BufferedOutputStream outStream) {
        boolean temp = false;
        float[][] dctArray1 = new float[8][8];
        double[][] dctArray2 = new double[8][8];
        int[] dctArray3 = new int[64];
        int[] lastDCvalue = new int[this.JpegObj.NumberOfComponents];
        int[] zeroArray = new int[64];
        int Width = 0;
        int Height = 0;
        boolean nothing = false;
        int MinBlockWidth = this.imageWidth % 8 != 0 ? (int)(Math.floor((double)this.imageWidth / 8.0) + 1.0) * 8 : this.imageWidth;
        int MinBlockHeight = this.imageHeight % 8 != 0 ? (int)(Math.floor((double)this.imageHeight / 8.0) + 1.0) * 8 : this.imageHeight;
        int comp = 0;
        while (comp < this.JpegObj.NumberOfComponents) {
            MinBlockWidth = Math.min(MinBlockWidth, this.JpegObj.BlockWidth[comp]);
            MinBlockHeight = Math.min(MinBlockHeight, this.JpegObj.BlockHeight[comp]);
            ++comp;
        }
        int xpos = 0;
        int r = 0;
        while (r < MinBlockHeight) {
            int c = 0;
            while (c < MinBlockWidth) {
                xpos = c * 8;
                int ypos = r * 8;
                comp = 0;
                while (comp < this.JpegObj.NumberOfComponents) {
                    Width = this.JpegObj.BlockWidth[comp];
                    Height = this.JpegObj.BlockHeight[comp];
                    float[][] inputArray = (float[][])this.JpegObj.Components[comp];
                    int i = 0;
                    while (i < this.JpegObj.VsampFactor[comp]) {
                        int j = 0;
                        while (j < this.JpegObj.HsampFactor[comp]) {
                            int xblockoffset = j * 8;
                            int yblockoffset = i * 8;
                            int a = 0;
                            while (a < 8) {
                                int b = 0;
                                while (b < 8) {
                                    dctArray1[a][b] = inputArray[ypos + yblockoffset + a][xpos + xblockoffset + b];
                                    ++b;
                                }
                                ++a;
                            }
                            dctArray2 = this.dct.forwardDCT(dctArray1);
                            dctArray3 = this.dct.quantizeBlock(dctArray2, this.JpegObj.QtableNumber[comp]);
                            this.Huf.HuffmanBlockEncoder(outStream, dctArray3, lastDCvalue[comp], this.JpegObj.DCtableNumber[comp], this.JpegObj.ACtableNumber[comp]);
                            lastDCvalue[comp] = dctArray3[0];
                            ++j;
                        }
                        ++i;
                    }
                    ++comp;
                }
                ++c;
            }
            if (r % 4 == 0) {
                IJ.showProgress((double)r / (double)MinBlockHeight);
            }
            ++r;
        }
        IJ.showProgress(1.0);
        this.Huf.flushBuffer(outStream);
    }

    public void WriteEOI(BufferedOutputStream out) {
        byte[] EOI = new byte[]{-1, -39};
        this.WriteMarker(EOI, out);
    }

    public void WriteHeaders(BufferedOutputStream out) {
        int j;
        byte[] SOI = new byte[]{-1, -40};
        this.WriteMarker(SOI, out);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        this.WriteArray(JFIF, out);
        String comment = new String();
        comment = this.JpegObj.getComment();
        int length = comment.length();
        byte[] COM = new byte[length + 4];
        COM[0] = -1;
        COM[1] = -2;
        COM[2] = (byte)(length >> 8 & 0xFF);
        COM[3] = (byte)(length & 0xFF);
        System.arraycopy(this.JpegObj.Comment.getBytes(), 0, COM, 4, this.JpegObj.Comment.length());
        this.WriteArray(COM, out);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        int i = 0;
        while (i < 2) {
            DQT[offset++] = (byte)(0 + i);
            int[] tempArray = (int[])this.dct.quantum[i];
            j = 0;
            while (j < 64) {
                DQT[offset++] = (byte)tempArray[jpegNaturalOrder[j]];
                ++j;
            }
            ++i;
        }
        this.WriteArray(DQT, out);
        byte[] SOF = new byte[19];
        SOF[0] = -1;
        SOF[1] = -64;
        SOF[2] = 0;
        SOF[3] = 17;
        SOF[4] = (byte)this.JpegObj.Precision;
        SOF[5] = (byte)(this.JpegObj.imageHeight >> 8 & 0xFF);
        SOF[6] = (byte)(this.JpegObj.imageHeight & 0xFF);
        SOF[7] = (byte)(this.JpegObj.imageWidth >> 8 & 0xFF);
        SOF[8] = (byte)(this.JpegObj.imageWidth & 0xFF);
        SOF[9] = (byte)this.JpegObj.NumberOfComponents;
        int index = 10;
        i = 0;
        while (i < SOF[9]) {
            SOF[index++] = (byte)this.JpegObj.CompID[i];
            SOF[index++] = (byte)((this.JpegObj.HsampFactor[i] << 4) + this.JpegObj.VsampFactor[i]);
            SOF[index++] = (byte)this.JpegObj.QtableNumber[i];
            ++i;
        }
        this.WriteArray(SOF, out);
        length = 2;
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        i = 0;
        while (i < 4) {
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)((int[])this.Huf.bits.elementAt(i))[0];
            j = 1;
            while (j < 17) {
                int temp = ((int[])this.Huf.bits.elementAt(i))[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
                ++j;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            j = 0;
            while (j < bytes) {
                DHT2[index++ - intermediateindex] = (byte)((int[])this.Huf.val.elementAt(i))[j];
                ++j;
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
            ++i;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        this.WriteArray(DHT4, out);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)this.JpegObj.NumberOfComponents;
        index = 5;
        i = 0;
        while (i < SOS[4]) {
            SOS[index++] = (byte)this.JpegObj.CompID[i];
            SOS[index++] = (byte)((this.JpegObj.DCtableNumber[i] << 4) + this.JpegObj.ACtableNumber[i]);
            ++i;
        }
        SOS[index++] = (byte)this.JpegObj.Ss;
        SOS[index++] = (byte)this.JpegObj.Se;
        SOS[index++] = (byte)((this.JpegObj.Ah << 4) + this.JpegObj.Al);
        this.WriteArray(SOS, out);
    }

    void WriteMarker(byte[] data, BufferedOutputStream out) {
        try {
            out.write(data, 0, 2);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    void WriteArray(byte[] data, BufferedOutputStream out) {
        try {
            int length = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF) + 2;
            out.write(data, 0, length);
        }
        catch (IOException e) {
            System.out.println("IO Error: " + e.getMessage());
        }
    }

    static {
        defaultQuality = 75;
        JpegEncoder.setQuality(Prefs.getInt("jpeg", defaultQuality));
        jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    }
}

