/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.ProgressBar;
import ij.io.FileInfo;
import ij.io.ImageReader;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class FileOpener {
    private FileInfo fi;
    private int width;
    private int height;

    public FileOpener(FileInfo fi) {
        this.fi = fi;
        if (fi != null) {
            this.width = fi.width;
            this.height = fi.height;
        }
    }

    public void open() {
        this.open(true);
    }

    public ImagePlus open(boolean show) {
        ImagePlus imp = null;
        Object pb = null;
        ColorModel cm = FileOpener.createColorModel(this.fi);
        if (this.fi.nImages > 1) {
            return this.openStack(cm, show);
        }
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 1: 
            case 2: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 3: 
            case 4: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp = new ImagePlus(this.fi.fileName, ip);
                break;
            }
            case 6: 
            case 7: {
                Object pixels = this.readPixels(this.fi);
                if (pixels == null) {
                    return null;
                }
                Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])pixels, 0, this.width));
                imp = new ImagePlus(this.fi.fileName, img);
            }
        }
        imp.setFileInfo(this.fi);
        FileOpener.setResolution(this.fi, imp);
        if (show) {
            imp.show();
        }
        IJ.showProgress(1.0);
        return imp;
    }

    ImagePlus openStack(ColorModel cm, boolean show) {
        ImageStack stack = new ImageStack(this.fi.width, this.fi.height, cm);
        int skip = this.fi.offset;
        try {
            ImageReader reader = new ImageReader(this.fi);
            InputStream is = FileOpener.createInputStream(this.fi);
            int i = 1;
            while (i <= this.fi.nImages) {
                IJ.showStatus("Reading: " + i + "/" + this.fi.nImages);
                Object pixels = reader.readPixels(is, skip);
                if (pixels == null) break;
                stack.addSlice(null, pixels);
                skip = this.fi.gapBetweenImages;
                IJ.showProgress((double)i / (double)this.fi.nImages);
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            IJ.write("" + e);
        }
        catch (OutOfMemoryError e) {
            IJ.outOfMemory(this.fi.fileName);
            stack.trim();
        }
        IJ.showProgress(1.0);
        if (stack.getSize() == 0) {
            return null;
        }
        ImagePlus imp = new ImagePlus(this.fi.fileName, stack);
        if (show) {
            imp.show();
        }
        imp.setFileInfo(this.fi);
        FileOpener.setResolution(this.fi, imp);
        IJ.showProgress(1.0);
        return imp;
    }

    public void revertToSaved(ImagePlus imp) {
        ProgressBar pb = IJ.getInstance().getProgressBar();
        if (this.fi.fileFormat == 3) {
            Image img = Toolkit.getDefaultToolkit().getImage(this.fi.directory + this.fi.fileName);
            imp.setImage(img);
            if (imp.getType() == 4) {
                Opener.convertGrayJpegTo8Bits(imp);
            }
            return;
        }
        if (this.fi.nImages > 1) {
            return;
        }
        if (this.fi.url == null || this.fi.url.equals("")) {
            IJ.showStatus("Loading: " + this.fi.directory + this.fi.fileName);
        } else {
            IJ.showStatus("Loading: " + this.fi.url + this.fi.fileName);
        }
        Object pixels = this.readPixels(this.fi);
        if (pixels == null) {
            return;
        }
        ColorModel cm = FileOpener.createColorModel(this.fi);
        switch (this.fi.fileType) {
            case 0: 
            case 5: {
                ByteProcessor ip = new ByteProcessor(this.width, this.height, (byte[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 1: 
            case 2: {
                ShortProcessor ip = new ShortProcessor(this.width, this.height, (short[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 3: 
            case 4: {
                FloatProcessor ip = new FloatProcessor(this.width, this.height, (float[])pixels, cm);
                imp.setProcessor(null, ip);
                break;
            }
            case 6: 
            case 7: {
                Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (int[])pixels, 0, this.width));
                imp.setImage(img);
            }
        }
    }

    static void setResolution(FileInfo fi, ImagePlus imp) {
        int f;
        Calibration cal = null;
        if (fi.pixelWidth > 0.0 && fi.unit != null) {
            cal = new Calibration(imp);
            cal.pixelWidth = fi.pixelWidth;
            cal.pixelHeight = fi.pixelHeight;
            cal.pixelDepth = fi.pixelDepth;
            cal.setUnit(fi.unit);
        }
        if (fi.valueUnit != null && ((f = fi.calibrationFunction) >= 0 && f <= 8 && fi.coefficients != null || f == 21)) {
            if (cal == null) {
                cal = new Calibration(imp);
            }
            cal.setFunction(f, fi.coefficients, fi.valueUnit);
        }
        if (cal != null) {
            imp.setCalibration(cal);
        }
    }

    public static ColorModel createColorModel(FileInfo fi) {
        if (fi.fileType == 5 && fi.lutSize > 0) {
            return new IndexColorModel(8, fi.lutSize, fi.reds, fi.greens, fi.blues);
        }
        return LookUpTable.createGrayscaleColorModel(fi.whiteIsZero);
    }

    public static InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        if (fi.inputStream != null) {
            return fi.inputStream;
        }
        if (fi.url != null && !fi.url.equals("")) {
            return new URL(fi.url + fi.fileName).openStream();
        }
        return new FileInputStream(new File(fi.directory + fi.fileName));
    }

    Object readPixels(FileInfo fi) {
        Object pixels = null;
        try {
            InputStream is = FileOpener.createInputStream(fi);
            ImageReader reader = new ImageReader(fi);
            pixels = reader.readPixels(is);
            is.close();
        }
        catch (Exception e) {
            IJ.write("FileOpener.readPixels(): " + e);
        }
        return pixels;
    }
}

