/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class TextRoi
extends Roi {
    static final int MAX_LINES = 50;
    private String[] theText = new String[50];
    private static String name = "SansSerif";
    private static int style = 0;
    private static int size = 18;
    private boolean firstChar = true;
    private int cline = 0;

    public TextRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.theText[0] = "Replace me";
    }

    public void addChar(char c) {
        if (c < ' ' && c != '\b' && c != '\n') {
            return;
        }
        if (this.firstChar) {
            this.cline = 0;
            this.theText[this.cline] = new String("");
            int i = 1;
            while (i < 50) {
                this.theText[i] = null;
                ++i;
            }
        }
        if (c == '\b') {
            if (this.theText[this.cline].length() > 0) {
                this.theText[this.cline] = this.theText[this.cline].substring(0, this.theText[this.cline].length() - 1);
            } else if (this.cline > 0) {
                this.theText[this.cline] = null;
                --this.cline;
            }
            this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            this.firstChar = false;
            return;
        }
        if (c == '\n') {
            if (this.cline < 49) {
                ++this.cline;
            }
        } else {
            char[] chr = new char[]{c};
            int n = this.cline;
            this.theText[n] = this.theText[n] + new String(chr);
            if (this.firstChar) {
                this.imp.draw(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
            } else {
                this.draw(this.ic.getGraphics());
            }
            this.firstChar = false;
            return;
        }
        this.theText[this.cline] = "";
    }

    public int[] getMask() {
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        Font font = new Font(name, style, size);
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        int i = 0;
        int yy = 0;
        while (i < 50 && this.theText[i] != null) {
            g.drawString(this.theText[i], 1, yy + fontHeight - descent + 1);
            ++i;
            yy += fontHeight;
        }
        g.dispose();
        ColorProcessor cp = new ColorProcessor(img);
        return (int[])cp.getPixels();
    }

    public void draw(Graphics g) {
        super.draw(g);
        double mag = this.ic.getMagnification();
        int sx = this.ic.screenX(this.x);
        int sy = this.ic.screenY(this.y);
        int swidth = (int)((double)this.width * mag);
        int sheight = (int)((double)this.height * mag);
        Font font = new Font(name, style, (int)((double)size * mag));
        FontMetrics metrics = g.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(font);
        Rectangle r = g.getClipBounds();
        g.setClip(sx, sy, swidth, sheight);
        int i = 0;
        while (i < 50 && this.theText[i] != null) {
            g.drawString(this.theText[i], sx + (int)mag, sy + fontHeight - descent + (int)mag);
            ++i;
            sy += fontHeight;
        }
        if (r != null) {
            g.setClip(r.x, r.y, r.width, r.height);
        }
    }

    public static String getFont() {
        return name;
    }

    public static int getSize() {
        return size;
    }

    public static int getStyle() {
        return style;
    }

    public static void setFont(String fontName, int fontSize, int fontStyle) {
        Roi roi;
        name = fontName;
        size = fontSize;
        style = fontStyle;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && (roi = imp.getRoi()) instanceof TextRoi) {
            imp.draw();
        }
    }
}

