/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.ProfilePlot;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    static final int LEFT_MARGIN = 50;
    static final int RIGHT_MARGIN = 20;
    static final int TOP_MARGIN = 20;
    static final int BOTTOM_MARGIN = 30;
    static final int WIDTH = 450;
    static final int HEIGHT = 200;
    static final String MIN = "pp.min";
    static final String MAX = "pp.max";
    static final String OPTIONS = "pp.options";
    static final int SAVE_X_VALUES = 1;
    static final int AUTO_CLOSE = 2;
    private int frameWidth;
    private int frameHeight;
    private int xloc;
    private int yloc;
    private Rectangle frame = null;
    private float[] xValues;
    private float[] yValues;
    private int nPoints;
    private double xScale;
    private double yScale;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private String xLabel;
    private String yLabel;
    private FontMetrics fm;
    private Font font = new Font("Helvetica", 0, 12);
    private boolean fixedYScale;
    private Graphics g;
    private static int options;
    public static boolean saveXValues;
    public static boolean autoClose;
    static /* synthetic */ Class class$ij$gui$PlotWindow;

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(new ImagePlus(title, GUI.createBlankImage(520, 250)));
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xValues = xValues;
        this.yValues = yValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.fixedYScale = true;
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.setup();
        int i = 0;
        while (i < x.length) {
            int xt = 50 + (int)(((double)x[i] - this.xMin) * this.xScale);
            int yt = 20 + this.frameHeight - (int)(((double)y[i] - this.yMin) * this.yScale);
            this.g.drawOval(xt - 2, yt - 2, 5, 5);
            ++i;
        }
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addLabel(double x, double y, String label) {
        this.setup();
        int xt = 50 + (int)(x * (double)this.frameWidth);
        int yt = 20 + (int)(y * (double)this.frameHeight);
        this.g.drawString(label, xt, yt);
    }

    public void draw() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button(" List ");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button("Copy...");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.coordinates = new Label("                     ");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.coordinates);
        this.add(buttons);
        this.pack();
        this.drawPlot();
        this.g.dispose();
        this.g = null;
        this.imp.setProcessor(null, new ColorProcessor(this.imp.getImage()));
        this.imp.updateAndDraw();
    }

    void setup() {
        if (this.g != null) {
            return;
        }
        this.g = this.imp.getImage().getGraphics();
        this.g.setColor(Color.black);
        this.g.setFont(this.font);
        if (this.frameWidth == 0) {
            this.frameWidth = 450;
            this.frameHeight = 200;
        }
        this.frame = new Rectangle(50, 20, this.frameWidth, this.frameHeight);
        this.xScale = this.xMax - this.xMin == 0.0 ? 1.0 : (double)this.frame.width / (this.xMax - this.xMin);
        this.yScale = this.yMax - this.yMin == 0.0 ? 1.0 : (double)this.frame.height / (this.yMax - this.yMin);
    }

    String d2s(double n) {
        if ((double)Math.round(n) == n) {
            return IJ.d2s(n, 0);
        }
        return IJ.d2s(n);
    }

    public void mouseMoved(int x, int y) {
        if (this.frame == null || this.coordinates == null) {
            return;
        }
        if (this.frame.contains(x, y)) {
            this.coordinates.setText("X=" + this.d2s((double)(x -= this.frame.x) / this.xScale + this.xMin) + ", Y=" + this.d2s((double)(this.frameHeight - (y -= this.frame.y)) / this.yScale + this.yMin));
        } else {
            this.coordinates.setText("");
        }
    }

    void drawPlot() {
        this.setup();
        this.g.drawRect(this.frame.x, this.frame.y, this.frame.width, this.frame.height);
        int[] xpoints = new int[this.nPoints];
        int[] ypoints = new int[this.nPoints];
        int i = 0;
        while (i < this.nPoints) {
            double value = this.yValues[i];
            if (value < this.yMin) {
                value = this.yMin;
            }
            if (value > this.yMax) {
                value = this.yMax;
            }
            xpoints[i] = 50 + (int)(((double)this.xValues[i] - this.xMin) * this.xScale);
            ypoints[i] = 20 + this.frame.height - (int)((value - this.yMin) * this.yScale);
            ++i;
        }
        this.g.drawPolyline(xpoints, ypoints, this.nPoints);
        String s = this.d2s(this.yMax);
        int sw = this.getWidth(s, this.g);
        if (sw + 4 > 50) {
            this.g.drawString(s, 4, 16);
        } else {
            this.g.drawString(s, 50 - this.getWidth(s, this.g) - 4, 30);
        }
        s = this.d2s(this.yMin);
        sw = this.getWidth(s, this.g);
        if (sw + 4 > 50) {
            this.g.drawString(s, 4, 20 + this.frame.height);
        } else {
            this.g.drawString(s, 50 - this.getWidth(s, this.g) - 4, 20 + this.frame.height);
        }
        int x = 50;
        int y = 20 + this.frame.height + 15;
        this.g.drawString(this.d2s(this.xMin), x, y);
        s = this.d2s(this.xMax);
        this.g.drawString(s, x + this.frame.width - this.getWidth(s, this.g) + 6, y);
        this.g.drawString(this.xLabel, 50 + (this.frame.width - this.getWidth(this.xLabel, this.g)) / 2, y + 3);
        this.drawYLabel(this.g, this.yLabel, 50, 20, this.frame.height);
    }

    void drawYLabel(Graphics g, String yLabel, int x, int y, int height) {
        if (yLabel.equals("")) {
            return;
        }
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        int w = this.fm.stringWidth(yLabel);
        int h = this.fm.getHeight();
        Image label = this.createImage(w, h);
        Graphics g2 = label.getGraphics();
        g2.setFont(this.font);
        int descent = this.fm.getDescent();
        g2.drawString(yLabel, 0, h - descent);
        g2.dispose();
        ImageProcessor ip = new ColorProcessor(label);
        ip = ip.rotateLeft();
        label = ip.createImage();
        int y2 = y + (height - this.getWidth(yLabel, g)) / 2;
        if (y2 < y) {
            y2 = y;
        }
        int x2 = x - h - 5;
        g.drawImage(label, x2, y2, null);
    }

    int getWidth(String s, Graphics g) {
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        return this.fm.stringWidth(s);
    }

    void showList() {
        if (saveXValues) {
            IJ.setColumnHeadings("X\tY");
        } else {
            IJ.setColumnHeadings("Y");
        }
        int i = 0;
        while (i < this.nPoints) {
            if (saveXValues) {
                IJ.write(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]));
            } else {
                IJ.write(this.d2s(this.yValues[i]));
            }
            ++i;
        }
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, "Save as Text...", 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus("Saving plot values...");
        int i = 0;
        while (i < this.nPoints) {
            if (saveXValues) {
                pw.println(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]));
            } else {
                pw.println(this.d2s(this.yValues[i]));
            }
            ++i;
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying plot values...");
        CharArrayWriter aw = new CharArrayWriter(this.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        int i = 0;
        while (i < this.nPoints) {
            if (saveXValues) {
                pw.print(this.d2s(this.xValues[i]) + "\t" + this.d2s(this.yValues[i]) + "\n");
            } else {
                pw.print(this.d2s(this.yValues[i]) + "\n");
            }
            ++i;
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else {
            this.copyToClipboard();
        }
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            ((Hashtable)prefs).put(MIN, Double.toString(min));
            ((Hashtable)prefs).put(MAX, Double.toString(max));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose) {
            options |= 2;
        }
        ((Hashtable)prefs).put(OPTIONS, Integer.toString(options));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        IJ.register(class$ij$gui$PlotWindow == null ? (class$ij$gui$PlotWindow = PlotWindow.class$("ij.gui.PlotWindow")) : class$ij$gui$PlotWindow);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
    }
}

