/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.ImagePlus;
import ij.gui.GUI;
import ij.gui.Line;
import ij.gui.Roi;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class OvalRoi
extends Roi {
    public OvalRoi(int x, int y, int width, int height, ImagePlus imp) {
        super(x, y, width, height, imp);
        this.type = 1;
    }

    public OvalRoi(int x, int y, ImagePlus imp) {
        super(x, y, imp);
        this.type = 1;
    }

    public void draw(Graphics g) {
        g.setColor(Roi.ROIColor);
        double mag = this.ic.getMagnification();
        g.drawOval(this.ic.screenX(this.x), this.ic.screenY(this.y), (int)((double)this.width * mag), (int)((double)this.height * mag));
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
        this.showStatus();
    }

    public void drawPixels() {
        double yy;
        ImageProcessor ip = this.imp.getProcessor();
        int a = this.width / 2;
        int b = this.height / 2;
        double a2 = a * a;
        double b2 = b * b;
        int xbase = this.x + a;
        int ybase = this.y + b;
        ip.moveTo(this.x, this.y + b);
        int i = -a + 1;
        while (i <= a) {
            yy = Math.sqrt(b2 * (1.0 - (double)(i * i) / a2));
            ip.lineTo(xbase + i, ybase + (int)(yy + 0.5));
            ++i;
        }
        ip.moveTo(this.x, this.y + b);
        int i2 = -a + 1;
        while (i2 <= a) {
            yy = Math.sqrt(b2 * (1.0 - (double)(i2 * i2) / a2));
            ip.lineTo(xbase + i2, ybase - (int)(yy + 0.5));
            ++i2;
        }
        if (Line.getWidth() > 1) {
            this.updateFullWindow = true;
        }
    }

    public boolean contains(int x, int y) {
        double b;
        double a;
        if (!super.contains(x, y)) {
            return false;
        }
        return (double)((x = Math.abs(x - (this.x + this.width / 2))) * x) / ((a = (double)(this.width / 2)) * a) + (double)((y = Math.abs(y - (this.y + this.height / 2))) * y) / ((b = (double)(this.height / 2)) * b) <= 1.0;
    }

    public int[] getMask() {
        Image img = GUI.createBlankImage(this.width, this.height);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        g.fillOval(0, 0, this.width, this.height);
        g.dispose();
        ColorProcessor cp = new ColorProcessor(img);
        return (int[])cp.getPixels();
    }

    public double getLength() {
        return Math.PI * (double)(this.width + this.height) / 2.0;
    }
}

