/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class RADRnav
extends AREAnav {
    private boolean isEastPositive = true;
    final double EARTH_RADIUS = 6371.23;
    final int MISS = -2139062144;
    int itype;
    double xrow;
    double xcol;
    double xlat;
    double xlon;
    double xrot;
    double xblat;
    double xblon;

    public RADRnav(int[] iparms) throws IllegalArgumentException {
        double xspace;
        if (iparms[0] != 1380009042) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        this.xlat = McIDASUtil.integerLatLonToDouble(iparms[3]);
        this.xlon = McIDASUtil.integerLatLonToDouble(iparms[4]);
        double yspace = xspace = (double)iparms[5] / 1000.0;
        if (iparms[7] != 0 && iparms[7] != -2139062144) {
            yspace = (double)iparms[7] / 1000.0;
        }
        this.xrot = -Math.PI / 180 * (double)iparms[6] / 1000.0;
        this.xblat = 111.19894090183831 / xspace;
        this.xblon = 111.19894090183831 / yspace;
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        int point = 0;
        while (point < number) {
            double xldif = this.xrow - imglinele[1][point];
            double xedif = this.xcol - imglinele[0][point];
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(this.xrot + xangl);
                xedif = xdis * Math.sin(this.xrot + xange);
            }
            double ylat = this.xlat + xldif / this.xblat;
            double ylon = this.xlon + xedif / this.xblon / Math.cos(ylat * (Math.PI / 180));
            if (this.isEastPositive) {
                ylon = -ylon;
            }
            latlon[0][point] = ylat;
            latlon[1][point] = ylon;
            ++point;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        int point = 0;
        while (point < number) {
            double zlat = latlon[0][point];
            double xrlat = zlat - this.xlat;
            double xldif = this.xblat * xrlat;
            double zlon = this.isEastPositive ? -latlon[1][point] : latlon[1][point];
            double xrlon = zlon - this.xlon;
            double xedif = xrlon * this.xblon * Math.cos(zlat * (Math.PI / 180));
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(-this.xrot + xangl);
                xedif = xdis * Math.sin(-this.xrot + xange);
            }
            linele[1][point] = this.xrow - xldif;
            linele[0][point] = this.xcol - xedif;
            ++point;
        }
        return this.imageCoordToAreaCoord(linele);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RADRnav)) {
            return false;
        }
        RADRnav that = (RADRnav)o;
        return super.equals(o) && that.xlat == this.xlat && that.xlon == this.xlon && that.xrow == this.xrow && that.xcol == this.xcol;
    }
}

