/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class McIDASUtil {
    public static final int MCMISSING = -2139062144;

    public static double integerLatLonToDouble(int value) {
        return McIDASUtil.mcPackedIntegerToDouble(value);
    }

    public static int doubleLatLonToInteger(double dvalue) {
        return McIDASUtil.mcDoubleToPackedInteger(dvalue);
    }

    public static double mcPackedIntegerToDouble(int value) {
        int val = value < 0 ? -value : value;
        double dvalue = (double)(val / 10000) + (double)(val / 100 % 100) / 60.0 + (double)(val % 100) / 3600.0;
        return value < 0 ? -dvalue : dvalue;
    }

    public static int mcDoubleToPackedInteger(double dvalue) {
        double dval = dvalue < 0.0 ? -dvalue : dvalue;
        int j = (int)(3600.0 * dval + 0.5);
        int value = 10000 * (j / 3600) + 100 * (j / 60 % 60) + j % 60;
        return dvalue < 0.0 ? -value : value;
    }

    public static double timdif(int yrday1, int hms1, int yrday2, int hms2) {
        long secs1 = McIDASUtil.mcDayTimeToSecs(yrday1, hms1);
        long secs2 = McIDASUtil.mcDayTimeToSecs(yrday2, hms2);
        return (double)(secs2 - secs1) / 60.0;
    }

    public static long mcDayTimeToSecs(int yearday, int time) {
        int year = yearday / 1000 % 1900 + 1900;
        int day = yearday % 1000;
        double seconds = McIDASUtil.mcPackedIntegerToDouble(time) * 3600.0;
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(0, 1);
        cal.set(1, year);
        cal.setLenient(true);
        cal.set(6, day);
        int secs = (int)Math.round(seconds * 1000.0) / 1000;
        cal.set(13, secs);
        cal.set(14, 0);
        return cal.getTime().getTime() / 1000L;
    }

    public static int[] mcSecsToDayTime(long secs) {
        int[] retvals = new int[2];
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTime(new Date(secs * 1000L));
        retvals[0] = cal.get(1) * 1000 + cal.get(6);
        retvals[1] = cal.get(11) * 10000 + cal.get(12) * 100 + cal.get(13);
        return retvals;
    }

    public static void flip(int[] array, int first, int last) {
        int i = first;
        while (i <= last) {
            int k = array[i];
            array[i] = k >>> 24 & 0xFF | k >>> 8 & 0xFF00 | (k & 0xFF) << 24 | (k & 0xFF00) << 8;
            ++i;
        }
    }

    public static int bytesToInteger(byte[] b, int off) {
        int k = (b[off] << 24) + (b[off + 1] << 16 & 0xFF0000) + (b[off + 2] << 8 & 0xFF00) + (b[off + 3] << 0 & 0xFF);
        return k;
    }

    public static int[] bytesToIntegerArray(byte[] b, int off, int num) {
        int[] values = new int[num];
        int i = 0;
        while (i < num) {
            byte[] bytes = new byte[4];
            System.arraycopy(b, i * 4, bytes, 0, 4);
            values[i] = McIDASUtil.bytesToInteger(bytes, 0);
            ++i;
        }
        return values;
    }

    public static String intBitsToString(int value) {
        byte[] bval = new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)((value & 0xFF) >>> 0)};
        return new String(bval);
    }

    public static String intBitsToString(int[] values) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < values.length) {
            sb.append(McIDASUtil.intBitsToString(values[i]));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isChar(int value) {
        String valueString = McIDASUtil.intBitsToString(value);
        char[] chars = valueString.toCharArray();
        int i = 0;
        while (i < 4) {
            if (!Character.UnicodeBlock.of(chars[i]).equals(Character.UnicodeBlock.BASIC_LATIN) || Character.isISOControl(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

