/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class AreaDirectory {
    private int[] dir = new int[64];
    private Date nominalTime;
    private Date startTime;
    private int[] bands;
    private double centerLatitude;
    private double centerLongitude;
    private double centerLatitudeResolution;
    private double centerLongitudeResolution;
    private Vector[] calInfo = null;
    private String calType;
    private String srcType;
    private String srcTypeOrig;
    private String memo;
    private String[] sensors = new String[]{"derived data", "test patterns", "graphics", "miscellaneous", "PDUS Meteosat visible", "PDUS Meteosat infrared", "PDUS Meteosat water vapor", "radar", "miscellaneous aircraft data", "raw Meteosat", "composite image", "topography image", "GMS visible", "GMS infrared", "ATS 6 visible", "ATS 6 infrared", "SMS-1 visible", "SMS-1 infrared", "SMS-2 visible", "SMS-2 infrared", "GOES-1 visible", "GOES-1 infrared", "GOES-2 visible", "GOES-2 infrared", "GOES-3 visible", "GOES-3 infrared", "GOES-4 visible (VAS)", "GOES-4 infrared and water vapor (VAS)", "GOES-5 visible (VAS)", "GOES-5 infrared and water vapor (VAS)", "GOES-6 visible", "GOES-6 infrared", "GOES-7 visible, Block 1 supplemental data", "GOES-7 infrared", "FY-2B", "FY-2C", "FY-2D", "FY-2E", "FY-2F", "FY-2G", "FY-2H", "TIROS-N (POES)", "NOAA-6", "NOAA-7", "NOAA-8", "NOAA-9", "Venus", "Voyager 1", "Voyager 2", "Galileo", "Hubble space telescope", "", "", "", "Meteosat-3", "Meteosat-4", "Meteosat-5", "Meteosat-6", "Meteosat-7", "", "NOAA-10", "NOAA-11", "NOAA-12", "NOAA-13", "NOAA-14", "NOAA-15", "NOAA-16", "NOAA-17", "NOAA-18", "NOAA-19", "GOES 8 imager", "GOES 8 sounder", "GOES 9 imager", "GOES 9 sounder", "GOES 10 imager", "GOES 10 sounder", "GOES 11 imager", "GOES 11 sounder", "GOES 12 imager", "GOES 12 sounder", "ERBE", "", "GMS-4", "GMS-5", "GMS-6", "GMS-7", "GMS-8", "DMSP F-8", "DMSP F-9", "DMSP F-10", "DMSP F-11", "DMSP F-12", "DMSP F-13", "DMSP F-14", "DMSP F-15", "FY-1B", "FY-1C", "FY-1D", "", "", "", "MODIS 1KM", "MODIS", "MODIS", "MODIS", "MODIS"};

    public AreaDirectory(int[] dirblock) throws AreaFileException {
        this.centerLatitude = Double.NaN;
        this.centerLongitude = Double.NaN;
        this.centerLatitudeResolution = Double.NaN;
        this.centerLongitudeResolution = Double.NaN;
        if (dirblock.length != 64) {
            throw new AreaFileException("Directory is not the right size");
        }
        this.dir = dirblock;
        if (this.dir[1] != 4) {
            McIDASUtil.flip(this.dir, 0, 19);
            if (this.dir[1] != 4) {
                throw new AreaFileException("Invalid version number - probably not an AREA file");
            }
            if ((this.dir[20] & 0xFFFF) == 0) {
                McIDASUtil.flip(this.dir, 20, 20);
            }
            McIDASUtil.flip(this.dir, 21, 23);
            McIDASUtil.flip(this.dir, 32, 50);
            McIDASUtil.flip(this.dir, 53, 55);
            McIDASUtil.flip(this.dir, 57, 63);
        }
        this.nominalTime = new Date(1000L * McIDASUtil.mcDayTimeToSecs(this.dir[3], this.dir[4]));
        this.startTime = this.dir[45] == 0 && this.dir[46] == 0 ? this.nominalTime : new Date(1000L * McIDASUtil.mcDayTimeToSecs(this.dir[45], this.dir[46]));
        int numbands = this.dir[13];
        this.bands = new int[numbands];
        int j = 0;
        int i = 0;
        while (i < 32) {
            int bandmask = 1 << i;
            if ((bandmask & this.dir[18]) == bandmask) {
                this.bands[j] = i + 1;
                ++j;
            }
            if (j > numbands) break;
            ++i;
        }
        if (numbands > 32) {
            int i2 = 0;
            while (i2 < 32) {
                int bandmask = 1 << i2;
                if ((bandmask & this.dir[19]) == bandmask) {
                    this.bands[j] = i2 + 33;
                    ++j;
                }
                if (j > numbands) break;
                ++i2;
            }
        }
        int[] memoArray = new int[8];
        System.arraycopy(this.dir, 24, memoArray, 0, memoArray.length);
        this.memo = McIDASUtil.intBitsToString(memoArray);
        this.calType = McIDASUtil.intBitsToString(this.dir[52]);
        this.srcType = McIDASUtil.intBitsToString(this.dir[51]);
        this.srcTypeOrig = McIDASUtil.intBitsToString(this.dir[56]);
        if (this.dir[56] == 0) {
            this.srcTypeOrig = this.srcType;
        }
    }

    public AreaDirectory(AreaDirectory directory) throws AreaFileException {
        this(directory.getDirectoryBlock());
    }

    public int getValue(int pointer) throws AreaFileException {
        if (pointer < 0 || pointer > 64) {
            throw new AreaFileException("Invalid pointer " + pointer);
        }
        return this.dir[pointer];
    }

    public int[] getDirectoryBlock() {
        return this.dir;
    }

    public Date getNominalTime() {
        return this.nominalTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getNumberOfBands() {
        return this.dir[13];
    }

    public int getLines() {
        return this.dir[8];
    }

    public int getElements() {
        return this.dir[9];
    }

    public void setCalInfo(Vector[] v) {
        this.calInfo = v;
    }

    public Vector[] getCalInfo() {
        return this.calInfo;
    }

    public int[] getBands() {
        return this.bands;
    }

    public String getMemoField() {
        return this.memo;
    }

    public String getSensorType() {
        return this.sensors[this.dir[2]];
    }

    public int getSensorID() {
        return this.dir[2];
    }

    public String getSourceType() {
        String r = this.srcType;
        if (r.equalsIgnoreCase("VISR")) {
            r = this.srcTypeOrig;
        }
        return r;
    }

    public String getCalibrationType() {
        return this.calType;
    }

    public double getCenterLatitude() {
        return this.centerLatitude;
    }

    public void setCenterLatitude(double lat) {
        this.centerLatitude = lat;
    }

    public double getCenterLongitude() {
        return this.centerLongitude;
    }

    public void setCenterLongitude(double lon) {
        this.centerLongitude = lon;
    }

    public double getCenterLatitudeResolution() {
        return this.centerLatitudeResolution;
    }

    public void setCenterLatitudeResolution(double res) {
        this.centerLatitudeResolution = res;
    }

    public double getCenterLongitudeResolution() {
        return this.centerLongitudeResolution;
    }

    public void setCenterLongitudeResolution(double res) {
        this.centerLongitudeResolution = res;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AreaDirectory)) {
            return false;
        }
        AreaDirectory that = (AreaDirectory)o;
        return this == that || Arrays.equals(this.getDirectoryBlock(), that.getDirectoryBlock());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdf.applyPattern("yyyy-MMM-dd  HH:mm:ss");
        buf.append("  ");
        buf.append(sdf.format(this.nominalTime, new StringBuffer(), new FieldPosition(0)).toString());
        buf.append("  ");
        buf.append(Integer.toString(this.getLines()));
        buf.append("  ");
        buf.append(Integer.toString(this.getElements()));
        buf.append("     ");
        int i = 0;
        while (i < this.bands.length) {
            buf.append(this.bands[i]);
            ++i;
        }
        return buf.toString();
    }
}

