/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GMSXnav;
import edu.wisc.ssec.mcidas.GOESnav;
import edu.wisc.ssec.mcidas.GVARnav;
import edu.wisc.ssec.mcidas.LAMBnav;
import edu.wisc.ssec.mcidas.MERCnav;
import edu.wisc.ssec.mcidas.MOLLnav;
import edu.wisc.ssec.mcidas.MSATnav;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.PSnav;
import edu.wisc.ssec.mcidas.RADRnav;
import edu.wisc.ssec.mcidas.RECTnav;
import edu.wisc.ssec.mcidas.TANCnav;
import java.io.Serializable;

public abstract class AREAnav
implements Serializable {
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final int DMSP = 1145918032;
    public static final int GMSX = 1196249944;
    public static final int GOES = 1196377427;
    public static final int GVAR = 1196835154;
    public static final int MOLL = 1297042508;
    public static final int MSAT = 1297301844;
    public static final int POES = 1414091343;
    public static final int RADR = 1380009042;
    public static final int RECT = 1380270932;
    public static final int PS = 1347624992;
    public static final int MERC = 1296388675;
    public static final int TANC = 1413566019;
    public static final int LAMB = 1279348034;
    public static final int LL = 123;
    public static final int XY = 234;
    public final int indexLine = 1;
    public final int indexEle = 0;
    public final int indexLat = 0;
    public final int indexLon = 1;
    private boolean isLineFlipped = false;
    private double lineOffset = 0.0;
    private float resLine = 1.0f;
    private float resElement = 1.0f;
    private float magLine = 1.0f;
    private float magElement = 1.0f;
    private float startLine = 0.0f;
    private float startElement = 0.0f;
    private float startImageLine = 0.0f;
    private float startImageElement = 0.0f;

    public abstract double[][] toLatLon(double[][] var1);

    public abstract double[][] toLinEle(double[][] var1);

    public void setRes(int resLine, int resElement) {
        this.resLine = resLine;
        this.resElement = resElement;
    }

    public void setRes(float resLine, float resElement) {
        this.resLine = resLine;
        this.resElement = resElement;
    }

    public void setMag(int magLine, int magElement) {
        this.magLine = magLine;
        this.magElement = magElement;
    }

    public void setMag(float magLine, float magElement) {
        this.magLine = magLine;
        this.magElement = magElement;
    }

    public void setStart(int startLine, int startElement) {
        this.startLine = startLine;
        this.startElement = startElement;
    }

    public void setImageStart(int startImageLine, int startImageElement) {
        this.startImageLine = startImageLine;
        this.startImageElement = startImageElement;
    }

    public void setFlipLineCoordinates(int line) {
        this.isLineFlipped = true;
        this.lineOffset = line;
    }

    public boolean isFlippedLineCoordinates() {
        return this.isLineFlipped;
    }

    public double getLineOffset() {
        return this.lineOffset;
    }

    public double[][] areaCoordToImageCoord(double[][] linele) {
        double[][] newvals = new double[2][linele[0].length];
        int i = 0;
        while (i < linele[0].length) {
            double line = this.isLineFlipped ? this.lineOffset - linele[1][i] : linele[1][i];
            newvals[1][i] = (double)this.startImageLine + (double)this.resLine * (line - (double)this.startLine) / (double)this.magLine;
            newvals[0][i] = (double)this.startImageElement + (double)this.resElement * (linele[0][i] - (double)this.startElement) / (double)this.magElement;
            ++i;
        }
        return newvals;
    }

    public double[][] imageCoordToAreaCoord(double[][] linele) {
        double[][] newvals = new double[2][linele[0].length];
        int i = 0;
        while (i < linele[0].length) {
            newvals[1][i] = (double)this.startLine + (double)this.magLine * (linele[1][i] - (double)this.startImageLine) / (double)this.resLine;
            if (this.isLineFlipped) {
                newvals[1][i] = this.lineOffset - newvals[1][i];
            }
            newvals[0][i] = (double)this.startElement + (double)this.magElement * (linele[0][i] - (double)this.startImageElement) / (double)this.resElement;
            ++i;
        }
        return newvals;
    }

    public static AREAnav makeAreaNav(int[] navBlock) throws McIDASException {
        AREAnav anav = null;
        try {
            switch (navBlock[0]) {
                case 1196835154: {
                    anav = new GVARnav(navBlock);
                    break;
                }
                case 1297042508: {
                    anav = new MOLLnav(navBlock);
                    break;
                }
                case 1297301844: {
                    anav = new MSATnav(navBlock);
                    break;
                }
                case 1380009042: {
                    anav = new RADRnav(navBlock);
                    break;
                }
                case 1380270932: {
                    anav = new RECTnav(navBlock);
                    break;
                }
                case 1196249944: {
                    anav = new GMSXnav(navBlock);
                    break;
                }
                case 1196377427: {
                    anav = new GOESnav(navBlock);
                    break;
                }
                case 1347624992: {
                    anav = new PSnav(navBlock);
                    break;
                }
                case 1296388675: {
                    anav = new MERCnav(navBlock);
                    break;
                }
                case 1279348034: {
                    anav = new LAMBnav(navBlock);
                    break;
                }
                case 1413566019: {
                    anav = new TANCnav(navBlock);
                    break;
                }
                default: {
                    throw new McIDASException("makeAreaNav: Unknown navigation type" + navBlock[0]);
                }
            }
        }
        catch (IllegalArgumentException excp) {
            throw new McIDASException("Wrong nav block passed to AREAnav module");
        }
        return anav;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AREAnav) {
            AREAnav nav = (AREAnav)obj;
            return this.resLine == nav.resLine && this.resElement == nav.resElement && this.magLine == nav.magLine && this.magElement == nav.magElement && this.startLine == nav.startLine && this.startElement == nav.startElement && this.startImageLine == nav.startImageLine && this.startImageElement == nav.startImageElement && this.isLineFlipped == nav.isLineFlipped && this.lineOffset == nav.lineOffset;
        }
        return false;
    }
}

