/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DataReadException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class DString
extends BaseType
implements ClientIO {
    private String val = "String value has not been set.";

    public DString() {
    }

    public DString(String n) {
        super(n);
    }

    public final String getValue() {
        return this.val;
    }

    public final void setValue(String newVal) {
        this.val = newVal;
    }

    public String getTypeName() {
        return "String";
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = \"" + Util.escattr(this.val) + "\";");
        } else {
            os.print("\"" + Util.escattr(this.val) + "\"");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int len = source.readInt();
        if (len < 0) {
            throw new DataReadException("Negative string length read.");
        }
        int modFour = len % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        byte[] byteArray = new byte[len];
        source.readFully(byteArray, 0, len);
        int i = 0;
        while (i < pad) {
            byte unused = source.readByte();
            ++i;
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(4 + len + pad);
        }
        try {
            this.val = new String(byteArray, 0, len, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("ISO8859_1 encoding not supported by this VM!");
            System.exit(1);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        try {
            byte[] byteArray = this.val.getBytes("ISO8859_1");
            sink.writeInt(byteArray.length);
            int modFour = byteArray.length % 4;
            int pad = modFour != 0 ? 4 - modFour : 0;
            sink.write(byteArray, 0, byteArray.length);
            int i = 0;
            while (i < pad) {
                sink.writeByte(pad);
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("ISO8859_1 encoding not supported by this VM!");
            System.exit(1);
        }
    }
}

