/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.Attribute;
import dods.dap.AttributeBadValueException;
import dods.dap.AttributeExistsException;
import dods.dap.NoSuchAttributeException;
import dods.util.SortedTable;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class AttributeTable
implements Cloneable {
    private static final boolean _Debug = false;
    private SortedTable attr;
    private String name;

    public AttributeTable() {
        this.attr = new SortedTable();
    }

    public AttributeTable(String name) {
        this.name = name;
        this.attr = new SortedTable();
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            AttributeTable at = (AttributeTable)super.clone();
            at.name = this.name;
            at.attr = new SortedTable();
            int i = 0;
            while (i < this.attr.size()) {
                String key = (String)this.attr.getKey(i);
                Attribute element = (Attribute)this.attr.elementAt(i);
                at.attr.put(key, element.clone());
                ++i;
            }
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Enumeration getNames() {
        return this.attr.keys();
    }

    public final Attribute getAttribute(String name) {
        return (Attribute)this.attr.get(name);
    }

    public final void appendAttribute(String name, int type, String value, boolean check) throws AttributeExistsException, AttributeBadValueException {
        Attribute a = (Attribute)this.attr.get(name);
        if (a != null && type != a.getType()) {
            throw new AttributeExistsException("`" + name + "' previously defined with a different type.");
        }
        if (a != null) {
            a.appendValue(value, check);
        } else {
            a = new Attribute(type, name, value, check);
            this.attr.put(name, a);
        }
    }

    public final void appendAttribute(String name, int type, String value) throws AttributeExistsException, AttributeBadValueException {
        this.appendAttribute(name, type, value, true);
    }

    public final AttributeTable appendContainer(String name) {
        if (this.attr.get(name) != null) {
            return null;
        }
        AttributeTable at = new AttributeTable(name);
        Attribute a = new Attribute(name, at);
        this.attr.put(name, a);
        return at;
    }

    public final void addAlias(String alias, String name) throws NoSuchAttributeException, AttributeExistsException {
        if (this.attr.get(alias) != null) {
            throw new AttributeExistsException("Could not alias `" + name + "' and `" + alias + "'.");
        }
        Attribute a = (Attribute)this.attr.get(name);
        if (a == null) {
            throw new NoSuchAttributeException("Could not alias `" + name + "' and `" + alias + "'.");
        }
        Attribute newAttr = new Attribute(name, a);
        this.attr.put(alias, newAttr);
    }

    public final void delAttribute(String name) {
        this.attr.remove(name);
    }

    public final void delAttribute(String name, int i) {
        if (i == -1) {
            this.attr.remove(name);
        } else {
            Attribute a = (Attribute)this.attr.get(name);
            if (a != null) {
                if (a.isContainer()) {
                    this.attr.remove(name);
                } else {
                    a.deleteValueAt(i);
                }
            }
        }
    }

    public void print(PrintWriter os, String pad) {
        Enumeration e = this.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Attribute a = this.getAttribute(name);
            if (a.isAlias()) {
                os.println(pad + "Alias " + name + " " + a.getAliasedTo() + ";");
                continue;
            }
            if (a.isContainer()) {
                os.println(pad + name + " {");
                a.getContainer().print(os, pad + "    ");
                os.println(pad + "}");
                continue;
            }
            os.print(pad + a.getTypeString() + " " + name + " ");
            Enumeration es = a.getValues();
            String val = (String)es.nextElement();
            while (es.hasMoreElements()) {
                os.print(val + ", ");
                val = (String)es.nextElement();
            }
            os.println(val + ";");
        }
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))), pad);
    }

    public final void print(PrintWriter os) {
        this.print(os, "    ");
    }

    public final void print(OutputStream os) {
        this.print(os, "    ");
    }
}

