/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import visad.DataReference;
import visad.DisplayImpl;
import visad.LocalDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.RemoteSourceListener;
import visad.VisADException;
import visad.util.ClientServer;
import visad.util.CmdlineConsumer;
import visad.util.CmdlineParser;

public abstract class TestSkeleton
extends Thread
implements CmdlineConsumer,
RemoteSourceListener {
    boolean startServer;
    String hostName;
    private static final int maximumWaitTime = 60;
    private CmdlineParser cmdline = new CmdlineParser(this);

    public TestSkeleton() {
    }

    public TestSkeleton(String[] args) throws RemoteException, VisADException {
        this();
        if (!this.processArgs(args)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.startThreads();
    }

    boolean hasClientServerMode() {
        return true;
    }

    public void initializeArgs() {
        this.startServer = false;
        this.hostName = null;
    }

    public int checkOption(String mainName, char ch, String arg) {
        if (ch == 'c') {
            if (arg == null) {
                System.err.println(mainName + ": Missing hostname for \"-c\"");
                return -1;
            }
            if (!this.hasClientServerMode()) {
                System.err.println("Client/server mode not supported for " + mainName);
                return -1;
            }
            if (this.startServer) {
                System.err.println(mainName + ": Cannot specify both '-c' and '-s'!");
                return -1;
            }
            this.hostName = arg;
            return 2;
        }
        if (ch == 's') {
            if (this.hostName != null) {
                System.err.println(mainName + ": Cannot specify both '-c' and '-s'!");
                return -1;
            }
            if (!this.hasClientServerMode()) {
                System.err.println("Client/server mode not supported for " + mainName);
                return -1;
            }
            this.startServer = true;
            return 1;
        }
        return 0;
    }

    public String optionUsage() {
        if (this.hasClientServerMode()) {
            return " [-c(lient) hostname] [-s(erver)]";
        }
        return "";
    }

    public int checkKeyword(String mainName, int argc, String[] args) {
        return 0;
    }

    public String keywordUsage() {
        return "";
    }

    public boolean finalizeArgs(String mainName) {
        return true;
    }

    boolean processArgs(String[] args) {
        return this.cmdline.processArgs(args);
    }

    boolean isServer() {
        return this.startServer && this.hostName == null;
    }

    boolean isClient() {
        return !this.startServer && this.hostName != null;
    }

    boolean isStandalone() {
        return !this.startServer && this.hostName == null;
    }

    String getClientServerTitle() {
        if (this.isServer()) {
            return " server";
        }
        if (this.isClient()) {
            return " client";
        }
        if (this.isStandalone()) {
            return " standalone";
        }
        return " unknown";
    }

    DataReference[] getClientDataReferences() throws RemoteException, VisADException {
        return null;
    }

    void finishClientSetup(RemoteServer client) throws RemoteException, VisADException {
    }

    public void dataSourceLost(String name) {
        System.err.println("Lost Data object \"" + name + "\"");
    }

    public void collabSourceLost(int connectionID) {
        System.err.println("Lost collaboration source #" + connectionID);
    }

    LocalDisplay[] setupClientData() throws RemoteException, VisADException {
        RemoteServer client;
        DataReference[] refs = this.getClientDataReferences();
        try {
            client = ClientServer.connectToServer(this.hostName, this.getClass().getName(), true);
        }
        catch (VisADException ve) {
            System.err.println(ve.getMessage());
            System.exit(1);
            client = null;
        }
        LocalDisplay[] dpys = ClientServer.getClientDisplays(client, refs);
        if (dpys == null) {
            throw new VisADException("No remote displays found!");
        }
        int i = 0;
        while (i < dpys.length) {
            ((DisplayImpl)dpys[i]).addRemoteSourceListener((RemoteSourceListener)this);
            ++i;
        }
        this.finishClientSetup(client);
        return dpys;
    }

    abstract DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException;

    abstract void setupServerData(LocalDisplay[] var1) throws RemoteException, VisADException;

    void setServerDataReferences(RemoteServerImpl server) throws RemoteException, VisADException {
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
    }

    public void startThreads() throws RemoteException, VisADException {
        LocalDisplay[] local;
        if (this.isClient()) {
            local = this.setupClientData();
        } else {
            RemoteServerImpl server;
            DisplayImpl[] displays = this.setupServerDisplays();
            if (!this.startServer) {
                server = null;
            } else {
                server = ClientServer.startServer(this.getClass().getName());
                if (displays != null) {
                    int i = 0;
                    while (i < displays.length) {
                        server.addDisplay(new RemoteDisplayImpl(displays[i]));
                        ++i;
                    }
                }
            }
            this.setServerDataReferences(server);
            local = displays;
            this.setupServerData(local);
        }
        this.setupUI(local);
    }

    public String toString() {
        return null;
    }
}

