/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import java.util.Random;
import visad.FieldImpl;
import visad.Gridded1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.MessageEvent;
import visad.MessageListener;
import visad.RealType;
import visad.RemoteData;
import visad.RemoteDisplayImpl;
import visad.RemoteFieldImpl;
import visad.Set;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class TestMsg {
    private static Random rand = null;
    private int numClients = 6;
    private int numMessages = 10;
    private long randSeed = -1L;
    private boolean verbose = false;

    public TestMsg(String[] args) {
        StupidData data;
        LocalDisplay[] dpys;
        if (!this.processArgs(args)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        if (rand == null) {
            rand = this.randSeed == -1L ? new Random() : new Random(this.randSeed);
        }
        if ((dpys = this.createAllDisplays()) == null) {
            System.err.println("Couldn't create Displays!");
            System.exit(1);
            return;
        }
        float[][] samples = new float[1][1];
        samples[0][0] = 0.0f;
        try {
            Gridded1DSet set = new Gridded1DSet((MathType)RealType.Generic, samples, samples.length);
            data = new StupidData(this, (Set)set);
            data.setSamples(samples);
        }
        catch (RemoteException re) {
            re.printStackTrace();
            data = null;
        }
        catch (VisADException ve) {
            ve.printStackTrace();
            data = null;
        }
        int i = 0;
        while (i < this.numMessages) {
            int n = rand.nextInt() % dpys.length;
            if (n < 0) {
                n = -n;
            }
            try {
                float[] fArray = samples[0];
                fArray[0] = fArray[0] + 1.0f;
                data.setSamples(samples);
            }
            catch (RemoteException re) {
                re.printStackTrace();
                data = null;
            }
            catch (VisADException ve) {
                ve.printStackTrace();
                data = null;
            }
            String msgStr = "Msg#" + i + " from dpy#" + n;
            try {
                dpys[n].sendMessage(new MessageEvent(msgStr, (RemoteData)new RemoteFieldImpl((FieldImpl)data)));
            }
            catch (RemoteException re) {
                System.err.println("Couldn't send message \"" + msgStr + "\":");
                re.printStackTrace();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++i;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        System.exit(0);
    }

    private LocalDisplay[] createAllDisplays() {
        RemoteDisplayImpl rmtSrvr;
        DisplayImplJ2D srvr;
        try {
            srvr = new DisplayImplJ2D("root");
        }
        catch (RemoteException re) {
            return null;
        }
        catch (VisADException ve) {
            return null;
        }
        srvr.addMessageListener((MessageListener)new MsgListener(this, "server"));
        LocalDisplay[] dpys = new LocalDisplay[this.numClients + 1];
        dpys[0] = srvr;
        try {
            rmtSrvr = new RemoteDisplayImpl(srvr);
        }
        catch (RemoteException re) {
            return null;
        }
        int i = 0;
        while (i < this.numClients) {
            try {
                dpys[i + 1] = new DisplayImplJ2D(rmtSrvr);
            }
            catch (RemoteException re) {
                return null;
            }
            catch (VisADException ve) {
                return null;
            }
            dpys[i + 1].addMessageListener((MessageListener)new MsgListener(this, "cli#" + i));
            ++i;
        }
        return dpys;
    }

    public boolean processArgs(String[] args) {
        boolean usage = false;
        String className = this.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        String progName = className.substring(pt == -1 ? 0 : pt + 1);
        int i = 0;
        while (args != null && i < args.length) {
            block21: {
                block20: {
                    if (args[i].length() <= 0 || args[i].charAt(0) != '-') break block20;
                    char ch = args[i].charAt(1);
                    switch (ch) {
                        case 'c': {
                            String str;
                            String string = args[i].length() > 2 ? args[i].substring(2) : (str = i + 1 < args.length ? args[++i] : null);
                            if (str == null) {
                                System.err.println(progName + ": Missing number of clients for \"-c\"");
                                usage = true;
                                break;
                            }
                            try {
                                this.numClients = Integer.parseInt(str);
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println(progName + ": Bad number of clients \"" + str + "\"");
                                this.numClients = 2;
                                usage = true;
                            }
                            if (this.numClients < 1) {
                                System.err.println(progName + ": Need at least one client!");
                                usage = true;
                                break;
                            }
                            break block21;
                        }
                        case 'm': {
                            String str;
                            String string = args[i].length() > 2 ? args[i].substring(2) : (str = i + 1 < args.length ? args[++i] : null);
                            if (str == null) {
                                System.err.println(progName + ": Missing number of messages for \"-m\"");
                                usage = true;
                                break;
                            }
                            try {
                                this.numMessages = Integer.parseInt(str);
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println(progName + ": Bad number of messages \"" + str + "\"");
                                this.numMessages = 2;
                                usage = true;
                            }
                            if (this.numMessages < 1) {
                                System.err.println(progName + ": Need at least one client!");
                                usage = true;
                                break;
                            }
                            break block21;
                        }
                        case 's': {
                            String str;
                            String string = args[i].length() > 2 ? args[i].substring(2) : (str = i + 1 < args.length ? args[++i] : null);
                            if (str == null) {
                                System.err.println(progName + ": Missing random seed value for \"-s\"");
                                usage = true;
                                break;
                            }
                            try {
                                this.randSeed = Long.parseLong(str);
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println(progName + ": Bad random seed value \"" + str + "\"");
                                usage = true;
                            }
                            break block21;
                        }
                        case 'v': {
                            this.verbose = true;
                            break;
                        }
                        default: {
                            System.err.println(progName + ": Unknown option \"-" + ch + "\"");
                            usage = true;
                        }
                    }
                    break block21;
                }
                System.err.println(progName + ": Unknown keyword \"" + args[i] + "\"");
                usage = true;
            }
            ++i;
        }
        if (usage) {
            System.err.println("Usage: " + this.getClass().getName() + " [-c numClients]" + " [-m numMessages]" + " [-s randomSeed]" + " [-v(erbose)]" + "");
        }
        return !usage;
    }

    public static void main(String[] args) {
        new TestMsg(args);
    }
}

