/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;

public class TestIDesk {
    private static int tracker_shmkey;
    private static int controller_shmkey;

    public static void main(String[] args) throws IOException, VisADException, RemoteException {
        if (args.length != 2) {
            System.err.println("must have 2 integer arguments");
            System.exit(1);
        }
        try {
            tracker_shmkey = Integer.parseInt(args[0]);
            controller_shmkey = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException exc) {
            System.err.println("args must be integers " + args[0] + " " + args[1]);
            System.exit(1);
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        gct3d.setStereo(1);
        GraphicsConfiguration config = gct3d.getBestConfiguration(gd.getConfigurations());
        if (config == null) {
            System.err.println("Unable to find a Stereo visual");
            System.exit(1);
        }
        ImmersaDeskDisplayRendererJ3D display_renderer = new ImmersaDeskDisplayRendererJ3D(tracker_shmkey, controller_shmkey);
        DisplayImplJ3D display = new DisplayImplJ3D("display1", (DisplayRendererJ3D)display_renderer, config);
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType count = RealType.getRealType("count", CommonUnit.second);
        FunctionType ir_histogram = new FunctionType(ir_radiance, count);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        int size = 64;
        FlatField histogram1 = FlatField.makeField(ir_histogram, size, false);
        Real direct = new Real(ir_radiance, 2.0);
        Real[] reals3 = new Real[]{new Real(count, 1.0), new Real(ir_radiance, 2.0), new Real(vis_radiance, 1.0)};
        RealTuple direct_tuple = new RealTuple(reals3);
        display.addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        display.addMap(new ScalarMap(ir_radiance, Display.XAxis));
        display.addMap(new ScalarMap(count, Display.YAxis));
        display.addMap(new ScalarMap(count, Display.Green));
        GraphicsModeControl mode = display.getGraphicsModeControl();
        mode.setPointSize(5.0f);
        mode.setPointMode(false);
        DataReferenceImpl ref_direct = new DataReferenceImpl("ref_direct");
        ref_direct.setData(direct);
        DataReference[] refs1 = new DataReference[]{ref_direct};
        display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), refs1, null);
        DataReferenceImpl ref_direct_tuple = new DataReferenceImpl("ref_direct_tuple");
        ref_direct_tuple.setData(direct_tuple);
        DataReference[] refs2 = new DataReference[]{ref_direct_tuple};
        display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), refs2, null);
        DataReferenceImpl ref_histogram1 = new DataReferenceImpl("ref_histogram1");
        ref_histogram1.setData(histogram1);
        DataReference[] refs3 = new DataReference[]{ref_histogram1};
        display.addReferences((DataRenderer)new DirectManipulationRendererJ3D(), refs3, null);
        JFrame frame = new JFrame("VisAD ImmersaDesk Test");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        int WIDTH = 1280;
        int HEIGHT = 1024;
        ((Component)frame).setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        ((Component)frame).setVisible(true);
    }
}

