/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Test51
extends TestSkeleton {
    public Test51() {
    }

    public Test51(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        dpys[0].addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpys[0].addMap(new ScalarMap(ir_radiance, Display.RGB));
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setTextureEnable(true);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    String getFrameTitle() {
        return "capture image in Java3D";
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JFrame jframe = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane((JPanel)dpys[0].getComponent());
        jframe.pack();
        ((Component)jframe).setVisible(true);
        JFrame jframe1 = new JFrame("captured image from Java3D");
        jframe1.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel1.setAlignmentY(0.0f);
        panel1.setAlignmentX(0.0f);
        jframe1.setContentPane(panel1);
        jframe1.pack();
        ((Component)jframe1).setSize(jframe.getSize().width, jframe.getSize().height);
        ((Component)jframe1).setVisible(true);
        while (true) {
            Graphics gp = panel1.getGraphics();
            BufferedImage image = dpys[0].getImage();
            gp.drawImage(image, 0, 0, panel1);
            gp.dispose();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
            }
        }
    }

    public String toString() {
        return ": image capture in Java3D";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test51(args);
    }
}

