/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Linear2DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class Test43
extends UISkeleton {
    public Test43() {
    }

    public Test43(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ2D("display1"), new DisplayImplJ2D("display2")};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        int jj;
        int ii;
        int index;
        int domain_flag = 0;
        int LengthX = 201;
        int LengthY = 201;
        int n_samples = LengthX * LengthY;
        Gridded2DSet domainSet = null;
        RealType x_axis = RealType.getRealType("x_axis", SI.meter);
        RealType y_axis = RealType.getRealType("y_axis", SI.meter);
        RealTupleType Domain2 = new RealTupleType(x_axis, y_axis);
        RealType rangeTemp = RealType.getRealType("Temperature", SI.kelvin);
        FunctionType domain_temp = new FunctionType(Domain2, rangeTemp);
        if (domain_flag == 0) {
            domainSet = new Linear2DSet((MathType)Domain2, 0.0, 1000.0, LengthX, 0.0, 1000.0, LengthY);
        } else if (domain_flag == 1) {
            float[][] d_samples = new float[2][n_samples];
            index = 0;
            ii = 0;
            while (ii < LengthY) {
                jj = 0;
                while (jj < LengthX) {
                    d_samples[0][index] = (float)jj * 5.0f;
                    d_samples[1][index] = (float)ii * 5.0f;
                    ++index;
                    ++jj;
                }
                ++ii;
            }
            domainSet = new Gridded2DSet((MathType)Domain2, d_samples, LengthX, LengthY, null, null, null);
        } else if (domain_flag == 3) {
            // empty if block
        }
        FlatField f_field = new FlatField(domain_temp, domainSet);
        double[][] samples = new double[1][n_samples];
        index = 0;
        double wave_number = 2.0;
        double PI = Math.PI;
        ii = 0;
        while (ii < LengthY) {
            jj = 0;
            while (jj < LengthX) {
                samples[0][index] = 50.0 * Math.sin(wave_number * 2.0 * PI / 1000.0 * 5.0 * (double)jj) * Math.sin(wave_number * 2.0 * PI / 1000.0 * 5.0 * (double)ii);
                ++index;
                ++jj;
            }
            ++ii;
        }
        f_field.setSamples(samples);
        System.out.println("Starting derivative computation...");
        FlatField d_field = (FlatField)f_field.derivative(x_axis, 202);
        System.out.println("...derivative done");
        RealType f_range = (RealType)((FunctionType)d_field.getType()).getRange();
        dpys[0].addMap(new ScalarMap(x_axis, Display.XAxis));
        dpys[0].addMap(new ScalarMap(y_axis, Display.YAxis));
        dpys[0].addMap(new ScalarMap(rangeTemp, Display.Green));
        dpys[0].addMap(new ConstantMap(0.5, Display.Red));
        dpys[0].addMap(new ConstantMap(0.5, Display.Blue));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setScaleEnable(true);
        dpys[1].addMap(new ScalarMap(x_axis, Display.XAxis));
        dpys[1].addMap(new ScalarMap(y_axis, Display.YAxis));
        dpys[1].addMap(new ScalarMap(f_range, Display.Green));
        dpys[1].addMap(new ConstantMap(0.5, Display.Red));
        dpys[1].addMap(new ConstantMap(0.5, Display.Blue));
        mode = dpys[1].getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(f_field);
        dpys[0].addReference(ref_imaget1, null);
        DataReferenceImpl ref_imaget2 = new DataReferenceImpl("ref_imaget2");
        ref_imaget2.setData(d_field);
        dpys[1].addReference(ref_imaget2, null);
    }

    String getFrameTitle() {
        return "sinusoidal field    and    (d/dx)field";
    }

    public String toString() {
        return ": Function.derivative with Linear2DSet in Java2D";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test43(args);
    }
}

