/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.AxisScale;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public class Test26
extends TestSkeleton {
    public Test26() {
    }

    public Test26(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        ScalarMap map1lat = new ScalarMap(RealType.Latitude, Display.YAxis);
        dpys[0].addMap(map1lat);
        AxisScale latScale = map1lat.getAxisScale();
        latScale.setTitle("Distance to Wall (m)");
        latScale.setColor(Color.green);
        latScale.setFont(Font.decode("serif"));
        ScalarMap map1lon = new ScalarMap(RealType.Longitude, Display.XAxis);
        map1lon.getAxisScale().setVisible(false);
        dpys[0].addMap(map1lon);
        ScalarMap map1vis = new ScalarMap(vis_radiance, Display.ZAxis);
        map1vis.setUnderscoreToBlank(true);
        map1vis.getAxisScale().setColor(new float[]{1.0f, 0.0f, 0.0f});
        dpys[0].addMap(map1vis);
        dpys[0].addMap(new ScalarMap(ir_radiance, Display.Green));
        dpys[0].addMap(new ConstantMap(0.5, Display.Blue));
        dpys[0].addMap(new ConstantMap(0.5, Display.Red));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        Vector v = dpys[0].getMapVector();
        ScalarMap map1lat = (ScalarMap)v.elementAt(0);
        ScalarMap map1lon = (ScalarMap)v.elementAt(1);
        ScalarMap map1vis = (ScalarMap)v.elementAt(2);
        boolean forever = true;
        while (forever) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.println("\ndelay\n");
            double[] range1lat = map1lat.getRange();
            double[] range1lon = map1lon.getRange();
            double[] range1vis = map1vis.getRange();
            double inclat = 0.05 * (range1lat[1] - range1lat[0]);
            double inclon = 0.05 * (range1lon[1] - range1lon[0]);
            double incvis = 0.05 * (range1vis[1] - range1vis[0]);
            map1lat.setRange(range1lat[1] + inclat, range1lat[0] - inclat);
            map1lat.getAxisScale().setMinorTickSpacing(map1lat.getAxisScale().getMajorTickSpacing() / 2.0);
            map1lon.setRange(range1lon[1] + inclon, range1lon[0] - inclon);
            boolean visible = !map1lon.getAxisScale().isVisible();
            map1lon.getAxisScale().setVisible(visible);
            map1vis.setRange(range1vis[1] + incvis, range1vis[0] - incvis);
        }
    }

    public String toString() {
        return ": scale";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test26(args);
    }
}

