/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.rmi.RemoteException;
import visad.ColorControl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ColorMapWidget;
import visad.util.LabeledColorWidget;

public class Test12
extends UISkeleton {
    boolean dynamic;

    public Test12() {
    }

    public Test12(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        this.dynamic = false;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        this.dynamic = true;
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earth_location = new RealTupleType(types);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType image_tuple = new FunctionType(earth_location, radiance);
        int size = 32;
        FlatField imaget1 = FlatField.makeField(image_tuple, size, false);
        dpys[0].addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpys[0].addMap(new ScalarMap(vis_radiance, Display.ZAxis));
        dpys[0].addMap(new ScalarMap(ir_radiance, Display.RGB));
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setTextureEnable(false);
        DataReferenceImpl ref_imaget1 = new DataReferenceImpl("ref_imaget1");
        ref_imaget1.setData(imaget1);
        dpys[0].addReference(ref_imaget1, null);
    }

    void setupUI(LocalDisplay[] dpys) throws RemoteException, VisADException {
        super.setupUI(dpys);
        if (this.dynamic) {
            ScalarMap colorMap = (ScalarMap)dpys[0].getMapVector().lastElement();
            ColorControl control = (ColorControl)colorMap.getControl();
            boolean growing = true;
            while (true) {
                int size;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                while ((size = growing ? control.getNumberOfColors() * 2 : control.getNumberOfColors() / 2) <= 4 || size > 1024) {
                    growing = !growing;
                }
                System.out.println("\n" + size + " colors\n");
                float[][] table = new float[3][size];
                float scale = 1.0f / ((float)size - 1.0f);
                int i = 0;
                while (i < size) {
                    table[0][i] = scale * (float)i;
                    table[1][i] = scale * (float)i;
                    table[2][i] = scale * (float)i;
                    ++i;
                }
                control.setTable(table);
            }
        }
    }

    String getFrameTitle() {
        return "VisAD Color Widget";
    }

    Component getSpecialComponent(LocalDisplay[] dpys) throws RemoteException, VisADException {
        ScalarMap colorMap = (ScalarMap)dpys[0].getMapVector().lastElement();
        if (this.dynamic) {
            return new LabeledColorWidget(colorMap);
        }
        return new LabeledColorWidget(new ColorMapWidget(colorMap, false));
    }

    public String toString() {
        return ": 2-D surface and ColorWidget";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test12(args);
    }
}

