/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.util.ContourWidget;
import visad.util.LabeledColorWidget;

public class Test01
extends UISkeleton {
    ScalarMap map1color = null;
    ScalarMap map1contour = null;
    static int size3d = 6;

    public Test01() {
    }

    public Test01(String[] args) throws RemoteException, VisADException {
        super(args);
    }

    public void initializeArgs() {
        size3d = 6;
    }

    public int checkKeyword(String testName, int argc, String[] args) {
        try {
            size3d = Integer.parseInt(args[0]);
            if (size3d < 1) {
                size3d = 6;
            }
        }
        catch (NumberFormatException e) {
            size3d = 6;
        }
        return 1;
    }

    DisplayImpl[] setupServerDisplays() throws RemoteException, VisADException {
        DisplayImpl[] dpys = new DisplayImpl[]{new DisplayImplJ3D("display", 3)};
        return dpys;
    }

    void setupServerData(LocalDisplay[] dpys) throws RemoteException, VisADException {
        RealType[] types3d = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius};
        RealTupleType earth_location3d = new RealTupleType(types3d);
        RealType vis_radiance = RealType.getRealType("vis_radiance", CommonUnit.degree);
        RealType ir_radiance = RealType.getRealType("ir_radiance", CommonUnit.degree);
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType grid_tuple = new FunctionType(earth_location3d, radiance);
        FlatField grid3d = FlatField.makeField(grid_tuple, size3d, false);
        ScalarMap lat_map = new ScalarMap(RealType.Latitude, Display.YAxis);
        dpys[0].addMap(lat_map);
        lat_map.setOverrideUnit(CommonUnit.radian);
        dpys[0].addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        dpys[0].addMap(new ScalarMap(RealType.Radius, Display.ZAxis));
        this.map1color = new ScalarMap(ir_radiance, Display.RGB);
        dpys[0].addMap(this.map1color);
        this.map1color.setOverrideUnit(CommonUnit.radian);
        this.map1contour = new ScalarMap(vis_radiance, Display.IsoContour);
        dpys[0].addMap(this.map1contour);
        this.map1contour.setOverrideUnit(CommonUnit.radian);
        GraphicsModeControl mode = dpys[0].getGraphicsModeControl();
        mode.setScaleEnable(true);
        DataReferenceImpl ref_grid3d = new DataReferenceImpl("ref_grid3d");
        ref_grid3d.setData(grid3d);
        dpys[0].addReference(ref_grid3d, null);
    }

    String getFrameTitle() {
        return "VisAD iso-level controls";
    }

    Component getSpecialComponent(LocalDisplay[] dpys) throws RemoteException, VisADException {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        panel.add(new ContourWidget(this.map1contour));
        panel.add(new LabeledColorWidget(this.map1color));
        return panel;
    }

    public String toString() {
        return ": colored iso-surfaces from regular grids and ContourWidget";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new Test01(args);
    }
}

