/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.SocketDataServer;
import visad.data.SocketDataSource;
import visad.java3d.DisplayImplJ3D;
import visad.util.Util;

public class SocketDataTest
extends JFrame
implements ActionListener {
    private boolean server;
    private DataReferenceImpl ref;
    private DisplayImpl disp;
    private JFileChooser dialog;
    private static final String usage = "Usage: java SocketDataTest [-s port] [-c ip.address:port]";

    private void constructGUI(String arg, boolean enableButtons) {
        this.dialog = Util.getVisADFileChooser();
        JPanel pane = new JPanel();
        this.setContentPane(pane);
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(this.disp.getComponent());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton load = new JButton("Load data");
        JButton reset = new JButton("Reset to default");
        load.addActionListener((ActionListener)this);
        load.setActionCommand("load");
        load.setEnabled(enableButtons);
        reset.addActionListener((ActionListener)this);
        reset.setActionCommand("reset");
        reset.setEnabled(enableButtons);
        buttons.add(load);
        buttons.add(reset);
        pane.add(buttons);
        this.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setTitle("SocketDataTest " + (this.server ? "server" : "client") + ": " + arg);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] argv) throws VisADException, RemoteException, IOException {
        if (argv.length < 2) {
            System.err.println("Not enough arguments.");
            System.err.println(usage);
            System.exit(1);
        }
        String sc = argv[0];
        String arg = argv[1];
        boolean serv = false;
        if (sc.equalsIgnoreCase("-s")) {
            serv = true;
        } else if (!sc.equalsIgnoreCase("-c")) {
            System.err.println("Please specify either -s or -c");
            System.err.println(usage);
            System.exit(2);
        }
        SocketDataTest test = new SocketDataTest(serv, arg);
    }

    public SocketDataTest(boolean serv, String arg) throws VisADException, RemoteException, IOException {
        this.server = serv;
        this.disp = new DisplayImplJ3D("disp");
        if (this.server) {
            int port = -1;
            try {
                port = Integer.parseInt(arg);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (port < 0 || port > 9999) {
                System.err.println("Invalid port: " + arg);
                System.exit(3);
            }
            this.ref = new DataReferenceImpl("ref");
            this.disp.addReference(this.ref);
            SocketDataServer server = new SocketDataServer(port, this.ref);
            this.loadData(null);
            this.constructGUI(arg, true);
        } else {
            SocketDataSource source = new SocketDataSource("SocketDataTest");
            source.open(arg);
            this.ref = source.getReference();
            this.disp.addReference(this.ref);
            2 mapsCell = new /* Unavailable Anonymous Inner Class!! */;
            mapsCell.addReference(this.ref);
            this.constructGUI(arg, false);
        }
    }

    private void loadData(String file) throws VisADException, RemoteException {
        DataImpl data = null;
        if (file == null) {
            int size = 64;
            RealType ir_radiance = RealType.getRealType("ir_radiance");
            RealType vis_radiance = RealType.getRealType("vis_radiance");
            RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
            RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
            RealTupleType earth_location = new RealTupleType(types);
            RealTupleType radiance = new RealTupleType(types2);
            FunctionType image_tuple = new FunctionType(earth_location, radiance);
            data = FlatField.makeField(image_tuple, size, false);
        } else {
            DefaultFamily loader = new DefaultFamily("loader");
            try {
                data = loader.open(file);
            }
            catch (BadFormException exc) {
                throw new VisADException(exc.getMessage());
            }
        }
        if (data != null) {
            this.setMaps((Data)data);
            this.ref.setData(data);
        }
    }

    private void setMaps(Data data) throws VisADException, RemoteException {
        ScalarMap[] maps = data.getType().guessMaps(true);
        this.disp.removeReference(this.ref);
        this.disp.clearMaps();
        int i = 0;
        while (i < maps.length) {
            this.disp.addMap(maps[i]);
            ++i;
        }
        this.disp.addReference(this.ref);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("load")) {
                int returnVal = this.dialog.showOpenDialog((Component)this);
                if (returnVal == 0) {
                    this.loadData(this.dialog.getSelectedFile().getAbsolutePath());
                }
            } else if (cmd.equals("reset")) {
                this.loadData(null);
            }
        }
        catch (VisADException exc) {
            exc.printStackTrace();
        }
        catch (RemoteException exc) {
            exc.printStackTrace();
        }
    }

    static /* synthetic */ DataReferenceImpl access$000(SocketDataTest x0) {
        return x0.ref;
    }

    static /* synthetic */ void access$100(SocketDataTest x0, Data x1) throws VisADException, RemoteException {
        x0.setMaps(x1);
    }
}

