/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.JFrame;
import visad.ColorControl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;

public class SatDisplay {
    private DisplayImpl display;

    public SatDisplay(String mapFile, String imageSource, boolean display3D, boolean remap) {
        try {
            ScalarMap lonMap;
            ScalarMap latMap;
            BaseMapAdapter baseMapAdapter = mapFile.indexOf("://") > 0 ? new BaseMapAdapter(new URL(mapFile)) : new BaseMapAdapter(mapFile);
            if (display3D) {
                this.display = new DisplayImplJ3D("display");
                latMap = new ScalarMap(RealType.Latitude, Display.Latitude);
                lonMap = new ScalarMap(RealType.Longitude, Display.Longitude);
            } else {
                this.display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
                latMap = new ScalarMap(RealType.Latitude, Display.YAxis);
                lonMap = new ScalarMap(RealType.Longitude, Display.XAxis);
            }
            this.display.addMap(latMap);
            this.display.addMap(lonMap);
            latMap.setRange(-90.0, 90.0);
            lonMap.setRange(-180.0, 180.0);
            DataReferenceImpl maplinesRef = new DataReferenceImpl("MapLines");
            maplinesRef.setData(baseMapAdapter.getData());
            ConstantMap[] maplinesConstantMap = new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(1.001, Display.Radius)};
            AreaAdapter areaAdapter = new AreaAdapter(imageSource);
            FlatField image = areaAdapter.getData();
            FunctionType imageFunctionType = (FunctionType)image.getType();
            RealTupleType imageDomainType = imageFunctionType.getDomain();
            RealTupleType imageRangeType = (RealTupleType)imageFunctionType.getRange();
            if (remap) {
                int SIZE = 256;
                RealTupleType latlonType = imageDomainType.getCoordinateSystem().getReference();
                Linear2DSet remapDomainSet = new Linear2DSet((MathType)latlonType, -4.0, 70.0, SIZE, -150.0, 5.0, SIZE);
                image = (FlatField)image.resample(remapDomainSet, 100, 202);
            }
            ScalarMap rgbMap = new ScalarMap((RealType)imageRangeType.getComponent(0), Display.RGB);
            this.display.addMap(rgbMap);
            ColorControl colorControl = (ColorControl)rgbMap.getControl();
            colorControl.initGreyWedge();
            DataReferenceImpl imageRef = new DataReferenceImpl("ImageRef");
            imageRef.setData(image);
            this.display.disableAction();
            this.display.addReference(imageRef, null);
            this.display.addReference(maplinesRef, maplinesConstantMap);
            this.display.enableAction();
        }
        catch (Exception ne) {
            ne.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        String mapFile = "ftp://www.ssec.wisc.edu/pub/visad-2.0/OUTLSUPW";
        String imageSource = "ftp://www.ssec.wisc.edu/pub/visad-2.0/AREA2001";
        boolean use3D = true;
        boolean remap = false;
        JFrame frame = new JFrame("Satellite Display");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        if (args.length > 0 && !args[0].equals("X")) {
            imageSource = args[0];
        }
        if (args.length == 2) {
            use3D = args[1].indexOf("2") < 0;
            remap = args[1].indexOf("2") < 0;
        }
        SatDisplay satDisplay = new SatDisplay(mapFile, imageSource, use3D, remap);
        frame.getContentPane().add(satDisplay.display.getComponent());
        ((Component)frame).setSize(500, 500);
        ((Component)frame).setVisible(true);
    }
}

