/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ContourControl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.HSVCoordinateSystem;
import visad.Linear3DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.util.VisADSlider;

public class HSVDisplay {
    public static void main(String[] args) throws IOException, VisADException, RemoteException {
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        RealType blue = RealType.getRealType("blue");
        RealTupleType rgb = new RealTupleType(red, green, blue);
        RealType hue = RealType.getRealType("hue", CommonUnit.degree);
        RealType saturation = RealType.getRealType("saturation");
        RealType value = RealType.getRealType("value");
        HSVCoordinateSystem hsv_system = new HSVCoordinateSystem(rgb);
        RealTupleType hsv = new RealTupleType(hue, saturation, value, hsv_system, null);
        Linear3DSet cube_set = new Linear3DSet(hsv, 0.0, 360.0, 37, 0.01, 1.0, 2, 0.01, 1.0, 2, null, new Unit[]{CommonUnit.degree, null, null}, null);
        DataReferenceImpl cube_ref = new DataReferenceImpl("cube");
        cube_ref.setData(cube_set);
        DataReferenceImpl hue_ref = new DataReferenceImpl("hue");
        DataReferenceImpl saturation_ref = new DataReferenceImpl("saturation");
        DataReferenceImpl value_ref = new DataReferenceImpl("value");
        VisADSlider hue_slider = new VisADSlider("hue", 0, 359, 0, 1.0, hue_ref, RealType.Generic);
        VisADSlider saturation_slider = new VisADSlider("saturation", 0, 100, 0, 0.01, saturation_ref, RealType.Generic);
        VisADSlider value_slider = new VisADSlider("value", 0, 100, 0, 0.01, value_ref, RealType.Generic);
        DisplayImplJ3D display1 = new DisplayImplJ3D("display1");
        display1.addMap(new ScalarMap(red, Display.XAxis));
        display1.addMap(new ScalarMap(green, Display.YAxis));
        display1.addMap(new ScalarMap(blue, Display.ZAxis));
        display1.addMap(new ScalarMap(hue, Display.Hue));
        display1.addMap(new ScalarMap(saturation, Display.Saturation));
        display1.addMap(new ScalarMap(value, Display.Value));
        ScalarMap maphcontour = new ScalarMap(hue, Display.IsoContour);
        display1.addMap(maphcontour);
        ContourControl controlhcontour = (ContourControl)maphcontour.getControl();
        ScalarMap mapscontour = new ScalarMap(saturation, Display.IsoContour);
        display1.addMap(mapscontour);
        ContourControl controlscontour = (ContourControl)mapscontour.getControl();
        ScalarMap mapvcontour = new ScalarMap(value, Display.IsoContour);
        display1.addMap(mapvcontour);
        ContourControl controlvcontour = (ContourControl)mapvcontour.getControl();
        display1.getGraphicsModeControl().setScaleEnable(true);
        DisplayRendererJ3D dr = (DisplayRendererJ3D)display1.getDisplayRenderer();
        KeyboardBehaviorJ3D kbd = new KeyboardBehaviorJ3D(dr);
        dr.addKeyboardBehavior(kbd);
        display1.addReference(cube_ref);
        JFrame frame = new JFrame("VisAD HSV Color Coordinates");
        frame.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(hue_slider);
        panel.add(saturation_slider);
        panel.add(value_slider);
        panel.add(display1.getComponent());
        int WIDTH = 500;
        int HEIGHT = 600;
        ((Component)frame).setSize(WIDTH, HEIGHT);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(screenSize.width / 2 - WIDTH / 2, screenSize.height / 2 - HEIGHT / 2);
        ((Component)frame).setVisible(true);
        HSVDisplay dummy = new HSVDisplay();
        ContourCell cell_hue = new ContourCell(dummy, controlhcontour, (DataReference)hue_ref);
        cell_hue.addReference(hue_ref);
        ContourCell cell_saturation = new ContourCell(dummy, controlscontour, (DataReference)saturation_ref);
        cell_saturation.addReference(saturation_ref);
        ContourCell cell_value = new ContourCell(dummy, controlvcontour, (DataReference)value_ref);
        cell_value.addReference(value_ref);
    }
}

