/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.rmi.RemoteException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Linear1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteServerImpl;
import visad.ScalarMap;
import visad.Tuple;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DisplayImplJ3D;
import visad.util.AnimationWidget;
import visad.util.ClientServer;
import visad.util.ContourWidget;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.ProjWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;

/*
 * Exception performing whole class analysis ignored.
 */
public class DisplaySwitch
extends Thread {
    private DisplayImpl display = null;
    private DataReferenceImpl[] dpyRefs = null;
    private Data alphaData0 = null;
    private Data betaData0 = null;
    private Data betaData1 = null;
    private ConstantMap[] betaConstMaps = null;
    private JPanel dpyPanel = null;
    private JButton switchDim = null;
    private JButton switchData = null;
    private boolean startServer = false;
    private String hostName = null;
    private static final int maximumWaitTime = 60;
    private boolean dpy3D = false;
    private boolean dpyBeta = false;

    public DisplaySwitch(String[] args) throws RemoteException, VisADException {
        if (!this.processArgs(args)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        this.startThreads();
    }

    public boolean processArgs(String[] args) {
        boolean usage = false;
        String className = this.getClass().getName();
        int pt = className.lastIndexOf(46);
        int ds = className.lastIndexOf(36);
        if (ds > pt) {
            pt = ds;
        }
        String progName = className.substring(pt == -1 ? 0 : pt + 1);
        int i = 0;
        while (args != null && i < args.length) {
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                char ch = args[i].charAt(1);
                switch (ch) {
                    case 'c': {
                        String str;
                        String string = args[i].length() > 2 ? args[i].substring(2) : (str = i + 1 < args.length ? args[++i] : null);
                        if (str == null) {
                            System.err.println(progName + ": Missing hostname for \"-c\"");
                            usage = true;
                            break;
                        }
                        if (this.startServer) {
                            System.err.println(progName + ": Cannot specify both '-c' and '-s'!");
                            usage = true;
                            break;
                        }
                        this.hostName = str;
                        break;
                    }
                    case 's': {
                        if (this.hostName != null) {
                            System.err.println(progName + ": Cannot specify both '-c' and '-s'!");
                            usage = true;
                            break;
                        }
                        this.startServer = true;
                        break;
                    }
                    default: {
                        System.err.println(progName + ": Unknown option \"-" + ch + "\"");
                        usage = true;
                        break;
                    }
                }
            } else {
                System.err.println(progName + ": Unknown keyword \"" + args[i] + "\"");
                usage = true;
            }
            ++i;
        }
        if (usage) {
            System.err.println("Usage: " + this.getClass().getName() + " [-c(lient) hostname] [-s(erver)]");
        }
        return !usage;
    }

    boolean isServer() {
        return this.startServer && this.hostName == null;
    }

    boolean isClient() {
        return !this.startServer && this.hostName != null;
    }

    boolean isStandalone() {
        return !this.startServer && this.hostName == null;
    }

    String getClientServerTitle() {
        if (this.isServer()) {
            return " server";
        }
        if (this.isClient()) {
            return " client";
        }
        if (this.isStandalone()) {
            return " standalone";
        }
        return " unknown";
    }

    LocalDisplay setupClientData() throws RemoteException, VisADException {
        RemoteServer client;
        try {
            client = ClientServer.connectToServer(this.hostName, this.getClass().getName(), true);
        }
        catch (VisADException ve) {
            System.err.println(ve.getMessage());
            System.exit(1);
            client = null;
        }
        LocalDisplay[] dpys = ClientServer.getClientDisplays(client);
        if (dpys == null) {
            throw new VisADException("No remote displays found!");
        }
        if (dpys.length != 1) {
            throw new VisADException("Multiple remote displays found!");
        }
        return dpys[0];
    }

    public void startThreads() throws RemoteException, VisADException {
        LocalDisplay local;
        if (this.isClient()) {
            local = this.setupClientData();
        } else {
            DisplayImpl dpy = this.setupServerDisplay();
            if (!this.startServer) {
                Object server = null;
            } else {
                RemoteServerImpl server = ClientServer.startServer(this.getClass().getName());
                if (dpy != null) {
                    server.addDisplay(new RemoteDisplayImpl(dpy));
                }
            }
            local = dpy;
            this.setupServerData(local);
        }
        this.setupUI(local);
    }

    DisplayImpl setupServerDisplay() throws RemoteException, VisADException {
        this.display = new DisplayImplJ2D("display");
        return this.display;
    }

    private static ScalarMap findMap(LocalDisplay dpy, RealType displayScalar) {
        Iterator maps;
        if (displayScalar == null) {
            return null;
        }
        try {
            maps = ((AbstractList)dpy.getMapVector()).iterator();
        }
        catch (Exception e) {
            maps = null;
        }
        if (maps != null) {
            while (maps.hasNext()) {
                ScalarMap smap = (ScalarMap)maps.next();
                if (!displayScalar.equals(smap.getDisplayScalar())) continue;
                return smap;
            }
        }
        try {
            maps = ((AbstractList)dpy.getConstantMapVector()).iterator();
        }
        catch (Exception e) {
            maps = null;
        }
        if (maps != null) {
            while (maps.hasNext()) {
                ConstantMap cmap = (ConstantMap)maps.next();
                if (!displayScalar.equals(cmap.getDisplayScalar())) continue;
                return cmap;
            }
        }
        return null;
    }

    private void buildMaps(LocalDisplay dpy) throws RemoteException, VisADException {
        RealType dom0 = RealType.getRealType("dom0");
        RealType dom1 = RealType.getRealType("dom1");
        dpy.addMap(new ScalarMap(RealType.Latitude, Display.XAxis));
        dpy.addMap(new ScalarMap(RealType.Longitude, Display.YAxis));
        dpy.addMap(new ScalarMap(dom1, Display.Green));
        dpy.addMap(new ConstantMap(0.5, Display.Blue));
        dpy.addMap(new ConstantMap(0.5, Display.Red));
        dpy.addMap(new ScalarMap(dom0, Display.IsoContour));
        dpy.addMap(new ScalarMap(dom1, Display.SelectRange));
        dpy.addMap(new ScalarMap(dom1, Display.RGBA));
        dpy.addMap(new ScalarMap(RealType.Time, Display.Animation));
    }

    private DataImpl buildAlphaRefZero() throws RemoteException, VisADException {
        RealType dom0 = RealType.getRealType("dom0");
        RealType dom1 = RealType.getRealType("dom1");
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType earthLocation = new RealTupleType(types);
        RealType[] viTypes = new RealType[]{dom0, dom1};
        RealTupleType viTT = new RealTupleType(viTypes);
        FunctionType viFunc = new FunctionType(earthLocation, viTT);
        RealType[] ivTypes = new RealType[]{dom1, dom0};
        RealTupleType ivTT = new RealTupleType(ivTypes);
        FunctionType ivFunc = new FunctionType(earthLocation, ivTT);
        RealType[] time = new RealType[]{RealType.Time};
        RealTupleType timeType = new RealTupleType(time);
        FunctionType timeVI = new FunctionType(timeType, viFunc);
        FunctionType timeIV = new FunctionType(timeType, ivFunc);
        int size = 64;
        int ntimes = 4;
        double start = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet timeSet = new Linear1DSet((MathType)timeType, start, start + 3000.0, ntimes);
        double[][] times = new double[][]{{start, start + 600.0, start + 1200.0, start + 1800.0, start + 2400.0, start + 3000.0}};
        Gridded1DDoubleSet timeGrid = new Gridded1DDoubleSet((MathType)timeType, times, times[0].length);
        FieldImpl setSequence = new FieldImpl(timeVI, timeSet);
        FieldImpl gridSequence = new FieldImpl(timeIV, timeGrid);
        FlatField flatVI = FlatField.makeField(viFunc, size, false);
        FlatField flatIV = FlatField.makeField(ivFunc, size, false);
        Real[] reals = new Real[]{new Real(dom0, (double)((float)size / 4.0f)), new Real(dom1, (double)((float)size / 8.0f))};
        RealTuple val = new RealTuple(reals);
        int i = 0;
        while (i < ntimes) {
            setSequence.setSample(i, (Data)flatVI);
            flatVI = (FlatField)flatVI.add(val);
            ++i;
        }
        int i2 = 0;
        while (i2 < times[0].length) {
            gridSequence.setSample(i2, (Data)flatIV);
            flatIV = (FlatField)flatIV.add(val);
            ++i2;
        }
        Data[] images = new FieldImpl[]{setSequence, gridSequence};
        return new Tuple(images);
    }

    void setupAlphaRefs(LocalDisplay dpy) throws RemoteException, VisADException {
        if (this.alphaData0 == null) {
            this.alphaData0 = this.buildAlphaRefZero();
        }
        this.dpyRefs = new DataReferenceImpl[1];
        this.dpyRefs[0] = new DataReferenceImpl("dpyRef0");
        this.dpyRefs[0].setData(this.alphaData0);
        dpy.addReference(this.dpyRefs[0], null);
    }

    private DataImpl buildBetaRefZero() throws RemoteException, VisADException {
        RealType dom0 = RealType.getRealType("dom0");
        RealType dom1 = RealType.getRealType("dom1");
        int isize = 16;
        RealTupleType revLocation = new RealTupleType(RealType.Longitude, RealType.Latitude);
        RealTupleType domTypes = new RealTupleType(dom0, dom1);
        FunctionType func = new FunctionType(revLocation, domTypes);
        FlatField flat = FlatField.makeField(func, isize, false);
        double[][] vals = new double[2][isize * isize];
        int i = 0;
        while (i < isize) {
            int j = 0;
            while (j < isize) {
                vals[0][j + isize * i] = (i + 1) * (j + 1);
                vals[1][j + isize * i] = (double)i * 1.2 * ((double)j / 1.2);
                ++j;
            }
            ++i;
        }
        return flat;
    }

    private DataImpl buildBetaRefOne() throws RemoteException, VisADException {
        RealType dom0 = RealType.getRealType("dom0");
        RealType dom1 = RealType.getRealType("dom1");
        int isize = 16;
        RealTupleType earthLocation = new RealTupleType(RealType.Latitude, RealType.Longitude);
        RealTupleType domTypes = new RealTupleType(dom0, dom1);
        FunctionType func = new FunctionType(earthLocation, domTypes);
        FlatField flat = FlatField.makeField(func, isize, false);
        double[][] vals = new double[2][isize * isize];
        int i = 0;
        while (i < isize) {
            int j = 0;
            while (j < isize) {
                vals[0][j + isize * i] = (i + 1) * (j + 1);
                vals[1][j + isize * i] = (double)i * 1.2 * ((double)j / 1.2);
                ++j;
            }
            ++i;
        }
        flat.setSamples(vals, false);
        return flat;
    }

    void setupBetaRefs(LocalDisplay dpy) throws RemoteException, VisADException {
        if (this.betaData0 == null) {
            this.betaData0 = this.buildBetaRefZero();
        }
        if (this.betaData1 == null) {
            this.betaData1 = this.buildBetaRefOne();
        }
        if (this.betaConstMaps == null) {
            this.betaConstMaps = new ConstantMap[3];
            this.betaConstMaps[0] = new ConstantMap(1.0, Display.Blue);
            this.betaConstMaps[1] = new ConstantMap(1.0, Display.Red);
            this.betaConstMaps[2] = new ConstantMap(0.0, Display.Green);
        }
        this.dpyRefs = new DataReferenceImpl[2];
        this.dpyRefs[0] = new DataReferenceImpl("dpyRef0");
        this.dpyRefs[0].setData(this.betaData0);
        dpy.addReference(this.dpyRefs[0], null);
        this.dpyRefs[1] = new DataReferenceImpl("dpyRef1");
        this.dpyRefs[1].setData(this.betaData1);
        dpy.addReference(this.dpyRefs[1], this.betaConstMaps);
    }

    void setupServerData(LocalDisplay dpy) throws RemoteException, VisADException {
        this.buildMaps(dpy);
        this.setupAlphaRefs(dpy);
    }

    void switchDisplay(boolean rerollData) {
        ScalarMap map;
        int i;
        DisplayImpl newDpy;
        int api;
        if (this.display == null) {
            System.err.println("No display found!");
            return;
        }
        String name = this.display.getName();
        try {
            api = this.display.getAPI();
        }
        catch (VisADException ve) {
            api = 0;
        }
        try {
            newDpy = this.dpy3D ? new DisplayImplJ3D(name, api) : new DisplayImplJ2D(name, api);
        }
        catch (Exception e) {
            System.err.println("Couldn't create new display!");
            return;
        }
        Vector sMaps = this.display.getMapVector();
        Vector cMaps = this.display.getConstantMapVector();
        try {
            this.dpyPanel.remove(this.display.getComponent());
            this.display.removeAllReferences();
            this.display.clearMaps();
            this.display = null;
        }
        catch (Exception e) {
            System.err.println("Ignoring " + e.getClass().getName() + ": " + e.getMessage());
        }
        if (sMaps != null) {
            int len = sMaps.size();
            i = 0;
            while (i < len) {
                map = (ScalarMap)sMaps.elementAt(i);
                try {
                    newDpy.addMap(map);
                }
                catch (Exception e) {
                    System.err.println("Couldn't re-add ScalarMap " + map + ": " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if (cMaps != null) {
            int len = cMaps.size();
            i = 0;
            while (i < len) {
                map = (ConstantMap)cMaps.elementAt(i);
                try {
                    newDpy.addMap(map);
                }
                catch (Exception e) {
                    System.err.println("Couldn't re-add ConstantMap " + map + ": " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                ++i;
            }
        }
        if (this.dpyRefs == null || rerollData) {
            if (this.dpyBeta) {
                try {
                    this.setupBetaRefs((LocalDisplay)newDpy);
                }
                catch (Exception e) {
                    System.err.println("Couldn't re-init beta refs: " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                try {
                    this.setupAlphaRefs((LocalDisplay)newDpy);
                }
                catch (Exception e) {
                    System.err.println("Couldn't re-init alpha refs: " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        } else {
            int i2 = 0;
            while (i2 < this.dpyRefs.length) {
                try {
                    newDpy.addReference(this.dpyRefs[i2], null);
                }
                catch (Exception e) {
                    System.err.println("Couldn't re-add " + this.dpyRefs[i2] + ": " + e.getClass().getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                ++i2;
            }
        }
        this.display = newDpy;
        this.dpyPanel.add(this.display.getComponent());
    }

    private Component buildSwitchButtons() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        this.switchDim = new JButton("Change to 3D");
        this.switchDim.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttons.add(this.switchDim);
        this.switchData = new JButton("Change Data");
        this.switchData.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        buttons.add(this.switchData);
        return buttons;
    }

    Component getSpecialComponent(LocalDisplay dpy) throws RemoteException, VisADException {
        Vector v = dpy.getMapVector();
        ScalarMap rgbaMap = DisplaySwitch.findMap((LocalDisplay)dpy, (RealType)Display.RGBA);
        JPanel widgets = new JPanel();
        widgets.setLayout(new BoxLayout(widgets, 1));
        this.dpyPanel = new JPanel();
        this.dpyPanel.add(dpy.getComponent());
        widgets.add(this.dpyPanel);
        widgets.add(new AnimationWidget(DisplaySwitch.findMap((LocalDisplay)dpy, (RealType)Display.Animation), 500));
        widgets.add(new ContourWidget(DisplaySwitch.findMap((LocalDisplay)dpy, (RealType)Display.IsoContour)));
        widgets.add(new GMCWidget(dpy.getGraphicsModeControl()));
        widgets.add(new LabeledColorWidget(rgbaMap));
        widgets.add(new ProjWidget(dpy.getProjectionControl()));
        widgets.add(new RangeWidget(rgbaMap));
        widgets.add(new SelectRangeWidget(DisplaySwitch.findMap((LocalDisplay)dpy, (RealType)Display.SelectRange)));
        if (this.isServer() || this.isStandalone()) {
            widgets.add(this.buildSwitchButtons());
        }
        return widgets;
    }

    void setupUI(LocalDisplay dpy) throws RemoteException, VisADException {
        Container content;
        Component special = this.getSpecialComponent(dpy);
        if (special instanceof Container) {
            content = (Container)special;
        } else {
            JPanel wrapper = new JPanel();
            wrapper.setLayout(new BorderLayout());
            wrapper.add("Center", special);
            content = wrapper;
        }
        JFrame jframe = new JFrame(this.getFrameTitle() + this.getClientServerTitle());
        jframe.addWindowListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
        jframe.setContentPane(content);
        jframe.pack();
        ((Component)jframe).setVisible(true);
    }

    String getFrameTitle() {
        return "2d/3d display switch";
    }

    public String toString() {
        return ": Changing between 2d and 3d display";
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new DisplaySwitch(args);
    }

    static /* synthetic */ boolean access$002(DisplaySwitch x0, boolean x1) {
        x0.dpy3D = x1;
        return x0.dpy3D;
    }

    static /* synthetic */ boolean access$000(DisplaySwitch x0) {
        return x0.dpy3D;
    }

    static /* synthetic */ JButton access$100(DisplaySwitch x0) {
        return x0.switchDim;
    }

    static /* synthetic */ boolean access$202(DisplaySwitch x0, boolean x1) {
        x0.dpyBeta = x1;
        return x0.dpyBeta;
    }

    static /* synthetic */ boolean access$200(DisplaySwitch x0) {
        return x0.dpyBeta;
    }
}

