/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.VariableIterator;

public class NetcdfFile {
    protected String name;
    protected String id;
    protected ucar.netcdf.NetcdfFile ncfile;
    protected ArrayList variables = new ArrayList();
    protected ArrayList dimensions = new ArrayList();
    protected ArrayList gattributes = new ArrayList();
    protected boolean isClosed = false;
    private int totalWidth = 80;
    private static char[] replaceChar = new char[]{'&', '<', '>', '\'', '\"', '\r', '\n'};
    private static String[] replaceWith = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;"};
    static /* synthetic */ Class class$java$lang$String;

    protected NetcdfFile() {
    }

    NetcdfFile(String filename, boolean readonly) throws IOException {
        this.ncfile = new ucar.netcdf.NetcdfFile(filename, readonly);
        this.name = filename;
        this.init(this.ncfile);
    }

    public NetcdfFile(String filename) throws IOException {
        this.ncfile = new ucar.netcdf.NetcdfFile(filename, true);
        this.name = filename;
        this.init(this.ncfile);
    }

    public NetcdfFile(URL url) throws IOException {
        this.ncfile = new ucar.netcdf.NetcdfFile(url);
        this.name = url.toString();
        this.init(this.ncfile);
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void close() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.isClosed = true;
    }

    protected void init(ucar.netcdf.NetcdfFile ncfile) {
        this.ncfile = ncfile;
        DimensionIterator diter = ncfile.getDimensions().iterator();
        while (diter.hasNext()) {
            this.dimensions.add(new Dimension(diter.next()));
        }
        VariableIterator viter = ncfile.iterator();
        while (viter.hasNext()) {
            this.variables.add(new Variable(viter.next(), this.dimensions));
        }
        AttributeIterator iter = ncfile.getAttributes().iterator();
        while (iter.hasNext()) {
            this.gattributes.add(new Attribute(iter.next()));
        }
    }

    public String getPathName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Iterator getVariableIterator() {
        return this.variables.iterator();
    }

    public List getVariables() {
        return this.variables;
    }

    public Variable findVariable(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = (Variable)this.variables.get(i);
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public Iterator getDimensionIterator() {
        return this.dimensions.iterator();
    }

    public Dimension findDimension(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = (Dimension)this.dimensions.get(i);
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    public Iterator getGlobalAttributeIterator() {
        return this.gattributes.iterator();
    }

    public List getGlobalAttributes() {
        return new ArrayList(this.gattributes);
    }

    public Attribute findGlobalAttribute(String name) {
        for (int i = 0; i < this.gattributes.size(); ++i) {
            Attribute a = (Attribute)this.gattributes.get(i);
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        for (int i = 0; i < this.gattributes.size(); ++i) {
            Attribute a = (Attribute)this.gattributes.get(i);
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public String findAttValueIgnoreCase(Variable v, String attName, String defaultValue) {
        String attValue = null;
        Attribute att = v == null ? this.findGlobalAttributeIgnoreCase(attName) : v.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue && (att = this.findGlobalAttributeIgnoreCase(attName)) != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    public List readArrays(List variables) throws IOException {
        ArrayList<Array> result = new ArrayList<Array>();
        for (int i = 0; i < variables.size(); ++i) {
            result.add(((Variable)variables.get(i)).read());
        }
        return result;
    }

    public String toStringDebug() {
        StringBuffer buff = new StringBuffer(2000);
        buff.setLength(0);
        buff.append("NETCDF file " + this.getPathName() + "\n");
        buff.append(this.ncfile.getDimensions().toString());
        buff.append(" Global Attributes:\n");
        buff.append(this.ncfile.getAttributes().toString());
        buff.append(" Variables:\n");
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = (Variable)this.variables.get(i);
            buff.append(v.toStringN());
        }
        return buff.toString();
    }

    public void writeCDL(OutputStream os) {
        PrintStream out = new PrintStream(os);
        this.toStringStart(out);
        this.toStringEnd(out);
        out.flush();
    }

    public String toString() {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(1000);
        PrintStream out = new PrintStream(ba);
        this.toStringStart(out);
        this.toStringEnd(out);
        out.flush();
        return ba.toString();
    }

    protected void toStringStart(PrintStream out) {
        int i;
        out.print("netcdf " + this.getPathName() + " {\n");
        out.print(" dimensions:\n");
        for (i = 0; i < this.dimensions.size(); ++i) {
            Dimension myd = (Dimension)this.dimensions.get(i);
            out.print(myd.toString());
            out.print("\n");
        }
        out.print("\n variables:\n");
        for (i = 0; i < this.variables.size(); ++i) {
            Variable v = (Variable)this.variables.get(i);
            out.print(v.toString());
        }
        Iterator iter = this.getGlobalAttributeIterator();
        if (iter.hasNext()) {
            out.print("\n // Global Attributes:\n");
        }
        while (iter.hasNext()) {
            Attribute att = (Attribute)iter.next();
            out.print("    :");
            out.print(att.toString());
            out.print(";");
            if (att.getValueType() != (class$java$lang$String == null ? NetcdfFile.class$("java.lang.String") : class$java$lang$String)) {
                out.print(" // " + att.getValueType().getName());
            }
            out.print("\n");
        }
        out.print("\n");
    }

    protected void toStringEnd(PrintStream out) {
        out.print("}\n");
    }

    public void writeNcML(OutputStream os) throws IOException {
        this.writeNcML(os, false, null);
    }

    public void writeNcML(OutputStream os, boolean showCoords, String uri) throws IOException {
        PrintStream out = new PrintStream(os);
        out.print("<?xml version='1.0' encoding='UTF-8'?>\n");
        out.print("<netcdf xmlns='http://www.ucar.edu/schemas/netcdf'\n");
        out.print("    xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n");
        out.print("    xsi:schemaLocation='http://www.ucar.edu/schemas/netcdf http://www.unidata.ucar.edu/schemas/netcdf.xsd'\n");
        if (this.id != null) {
            out.print("    id='" + this.quote(this.getId()) + "' >\n");
        }
        if (uri != null) {
            out.print("    uri='" + this.quote(uri) + "' >\n\n");
        } else {
            out.print("    uri='" + this.quote(this.getPathName()) + "' >\n\n");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = (Dimension)this.dimensions.get(i);
            out.print("  <dimension name='" + this.quote(dim.getName()) + "' length='" + dim.getLength() + "'");
            if (dim.isUnlimited()) {
                out.print(" isUnlimited='true'");
            }
            out.print(" />\n");
        }
        out.print("\n");
        Iterator giter = this.getGlobalAttributeIterator();
        while (giter.hasNext()) {
            Attribute att = (Attribute)giter.next();
            this.writeNcmlAtt(att, out);
        }
        out.print("\n");
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = (Variable)this.variables.get(i);
            out.print("  <variable name='" + this.quote(v.getName()) + "' type='" + v.getDataType() + "'");
            if (v.getRank() > 0) {
                out.print(" shape='");
                List dims = v.getDimensions();
                for (int j = 0; j < dims.size(); ++j) {
                    Dimension dim = (Dimension)dims.get(j);
                    if (j != 0) {
                        out.print(" ");
                    }
                    out.print(this.quote(dim.getName()));
                }
                out.print("'");
            }
            boolean closed = false;
            List atts = v.getAttributes();
            if (atts.size() > 0) {
                if (!closed) {
                    out.print(" >\n");
                    closed = true;
                }
                Iterator iter = atts.iterator();
                while (iter.hasNext()) {
                    Attribute att = (Attribute)iter.next();
                    out.print("  ");
                    this.writeNcmlAtt(att, out);
                }
            }
            if (showCoords && v.isCoordinateVariable()) {
                if (!closed) {
                    out.print(" >\n");
                    closed = true;
                }
                this.writeNcmlData(v, out);
            }
            if (!closed) {
                out.print(" />\n");
                continue;
            }
            out.print("  </variable>\n");
        }
        out.print("</netcdf>\n");
        out.flush();
    }

    private void writeNcmlAtt(Attribute att, PrintStream out) {
        out.print("  <attribute name='" + this.quote(att.getName()) + "' type='" + att.getDataType() + "' value='");
        if (att.isString()) {
            out.print(this.quote(att.getStringValue()));
        } else {
            for (int i = 0; i < att.getLength(); ++i) {
                out.print(att.getNumericValue(i) + " ");
            }
        }
        out.print("' />\n");
    }

    private void writeNcmlData(Variable v, PrintStream out) throws IOException {
        Array data = v.read();
        StringBuffer buff = new StringBuffer(1000);
        int width = this.format("    <values>", out, 0);
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            width = this.format(ii.next() + " ", out, width);
        }
        this.format(" </values>\n", out, width);
    }

    private int format(String s, PrintStream out, int width) {
        int len = s.length();
        if (len + width > this.totalWidth) {
            out.print("\n    ");
            width = 4;
        }
        out.print(s);
        return width += len;
    }

    String quote(String x) {
        boolean ok = true;
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            ok &= pos < 0;
        }
        if (ok) {
            return x;
        }
        StringBuffer result = new StringBuffer(x);
        for (int i = 0; i < replaceChar.length; ++i) {
            int pos = x.indexOf(replaceChar[i]);
            if (pos < 0) continue;
            this.replace(result, replaceChar[i], replaceWith[i]);
        }
        return result.toString();
    }

    private void replace(StringBuffer sb, char out, String in) {
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != out) continue;
            sb.replace(i, i + 1, in);
            i += in.length();
        }
    }

    public static void main(String[] arg) throws Exception {
        try {
            NetcdfFile file = new NetcdfFile("C:/dev/netcdf/test/data/example.nc");
            System.out.println(file.toString());
            file.writeNcML(System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

