/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

public class IndexIterator {
    protected final int[] counter;
    protected final int[] limits;
    protected int ncycles;

    public static boolean isZero(int[] iv) {
        for (int ii = 0; ii < iv.length; ++ii) {
            if (iv[ii] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] lhs, int[] rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int ii = 0; ii < lhs.length; ++ii) {
            if (lhs[ii] == rhs[ii]) continue;
            return false;
        }
        return true;
    }

    public IndexIterator(int[] theLimits) {
        this.counter = new int[theLimits.length];
        this.limits = theLimits;
        this.ncycles = 0;
    }

    public IndexIterator(int[] initCounter, int[] theLimits) {
        this.counter = initCounter == null ? new int[theLimits.length] : (int[])initCounter.clone();
        this.limits = theLimits;
        this.ncycles = 0;
    }

    public boolean notDone() {
        return this.ncycles <= 0;
    }

    public int[] value() {
        return this.counter;
    }

    public void incr() {
        int digit = this.counter.length - 1;
        if (digit < 0) {
            ++this.ncycles;
            return;
        }
        while (digit >= 0) {
            int n = digit;
            this.counter[n] = this.counter[n] + 1;
            if (this.counter[digit] < this.limits[digit]) break;
            this.counter[digit] = 0;
            if (digit == 0) {
                ++this.ncycles;
                break;
            }
            --digit;
        }
    }

    public void advance(int nsteps) {
        while (nsteps-- > 0) {
            this.incr();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int last = this.counter.length - 1;
        for (int ii = 0; ii <= last; ++ii) {
            buf.append(this.counter[ii]);
            if (ii == last) break;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int ii;
        int[] edges = new int[args.length];
        for (ii = 0; ii < args.length; ++ii) {
            Integer av = new Integer(args[ii]);
            edges[ii] = av;
        }
        System.out.println(edges);
        IndexIterator odo = new IndexIterator(edges);
        ii = 0;
        while (odo.notDone()) {
            System.out.println(odo);
            odo.incr();
            ++ii;
        }
        System.out.print("\t");
        System.out.println(ii);
    }
}

