/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.IndexImpl;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MultiArray;

public class MultiArraySection
implements MultiArray {
    private MultiArray ma;
    private int rank;
    private int[] maShape;
    private int[] orgOrigin;
    private long size;

    public MultiArraySection(MultiArray ma, int[] origin, int[] shape) throws InvalidRangeException {
        this.ma = ma;
        this.rank = ma.getRank();
        if (origin.length != ma.getRank()) {
            throw new IllegalArgumentException("MultiArraySection: Bad origin[] length");
        }
        if (shape.length != ma.getRank()) {
            throw new IllegalArgumentException("MultiArraySection: Bad shape[] length");
        }
        int[] orgShape = ma.getShape();
        for (int ii = 0; ii < shape.length; ++ii) {
            if (origin[ii] < 0 || origin[ii] >= orgShape[ii]) {
                throw new IllegalArgumentException("MultiArraySection: Bad origin value at index " + ii + " == " + origin[ii]);
            }
            if (shape[ii] >= 0 && origin[ii] + shape[ii] <= orgShape[ii]) continue;
            throw new IllegalArgumentException("MultiArraySection: Bad shape value at index " + ii + " == " + shape[ii]);
        }
        this.orgOrigin = (int[])origin.clone();
        this.maShape = (int[])shape.clone();
        this.size = IndexImpl.computeSize(this.maShape);
    }

    public Class getElementType() {
        return this.ma.getElementType();
    }

    public int getRank() {
        return this.rank;
    }

    public long getSize() {
        return this.size;
    }

    public int[] getShape() {
        return (int[])this.maShape.clone();
    }

    public Array read(int[] origin, int[] shape) throws InvalidRangeException, IOException {
        int[] readOrigin = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            readOrigin[i] = this.orgOrigin[i] + origin[i];
        }
        return this.ma.read(readOrigin, shape);
    }

    public Array read() throws IOException {
        try {
            return this.ma.read(this.orgOrigin, this.maShape);
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException();
        }
    }
}

