/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.ArrayAbstract;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.Index0D;
import ucar.ma2.Index1D;
import ucar.ma2.Index2D;
import ucar.ma2.Index3D;
import ucar.ma2.Index4D;
import ucar.ma2.Index5D;
import ucar.ma2.Index6D;
import ucar.ma2.Index7D;
import ucar.ma2.IndexImpl;
import ucar.ma2.IndexIterator;

public class ArrayDouble
extends ArrayAbstract {
    protected double[] storageD;

    static ArrayDouble factory(IndexImpl index) {
        return ArrayDouble.factory(index, null);
    }

    static ArrayDouble factory(IndexImpl index, double[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(index, storage);
            }
            case 1: {
                return new D1(index, storage);
            }
            case 2: {
                return new D2(index, storage);
            }
            case 3: {
                return new D3(index, storage);
            }
            case 4: {
                return new D4(index, storage);
            }
            case 5: {
                return new D5(index, storage);
            }
            case 6: {
                return new D6(index, storage);
            }
            case 7: {
                return new D7(index, storage);
            }
        }
        return new ArrayDouble(index, storage);
    }

    public ArrayDouble(int[] shape) {
        super(shape);
        this.storageD = new double[(int)this.indexCalc.getSize()];
    }

    ArrayAbstract createView(IndexImpl index) {
        return ArrayDouble.factory(index, this.storageD);
    }

    private ArrayDouble(IndexImpl ima, double[] data) {
        super(ima);
        this.storageD = data != null ? data : new double[(int)this.indexCalc.getSize()];
    }

    public Object getStorage() {
        return this.storageD;
    }

    void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            iter.setDoubleNext(ja[i]);
        }
    }

    void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        double[] ja = (double[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getDoubleNext();
        }
    }

    public Class getElementType() {
        return Double.TYPE;
    }

    public double get(Index i) {
        return this.storageD[i.currentElement()];
    }

    public void set(Index i, double value) {
        this.storageD[i.currentElement()] = value;
    }

    public double getDouble(Index i) {
        return this.storageD[i.currentElement()];
    }

    public void setDouble(Index i, double value) {
        this.storageD[i.currentElement()] = value;
    }

    public float getFloat(Index i) {
        return (float)this.storageD[i.currentElement()];
    }

    public void setFloat(Index i, float value) {
        this.storageD[i.currentElement()] = value;
    }

    public long getLong(Index i) {
        return (long)this.storageD[i.currentElement()];
    }

    public void setLong(Index i, long value) {
        this.storageD[i.currentElement()] = value;
    }

    public int getInt(Index i) {
        return (int)this.storageD[i.currentElement()];
    }

    public void setInt(Index i, int value) {
        this.storageD[i.currentElement()] = value;
    }

    public short getShort(Index i) {
        return (short)this.storageD[i.currentElement()];
    }

    public void setShort(Index i, short value) {
        this.storageD[i.currentElement()] = value;
    }

    public byte getByte(Index i) {
        return (byte)this.storageD[i.currentElement()];
    }

    public void setByte(Index i, byte value) {
        this.storageD[i.currentElement()] = value;
    }

    public char getChar(Index i) {
        return (char)this.storageD[i.currentElement()];
    }

    public void setChar(Index i, char value) {
        this.storageD[i.currentElement()] = value;
    }

    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    public Object getObject(Index i) {
        return new Double(this.storageD[i.currentElement()]);
    }

    public void setObject(Index i, Object value) {
        this.storageD[i.currentElement()] = ((Number)value).doubleValue();
    }

    double getDouble(int index) {
        return this.storageD[index];
    }

    void setDouble(int index, double value) {
        this.storageD[index] = value;
    }

    float getFloat(int index) {
        return (float)this.storageD[index];
    }

    void setFloat(int index, float value) {
        this.storageD[index] = value;
    }

    long getLong(int index) {
        return (long)this.storageD[index];
    }

    void setLong(int index, long value) {
        this.storageD[index] = value;
    }

    int getInt(int index) {
        return (int)this.storageD[index];
    }

    void setInt(int index, int value) {
        this.storageD[index] = value;
    }

    short getShort(int index) {
        return (short)this.storageD[index];
    }

    void setShort(int index, short value) {
        this.storageD[index] = value;
    }

    byte getByte(int index) {
        return (byte)this.storageD[index];
    }

    void setByte(int index, byte value) {
        this.storageD[index] = value;
    }

    char getChar(int index) {
        return (char)this.storageD[index];
    }

    void setChar(int index, char value) {
        this.storageD[index] = value;
    }

    boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    Object getObject(int index) {
        return new Double(this.getDouble(index));
    }

    public static class D7
    extends ArrayDouble {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayDouble {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m, int n) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayDouble {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l, int m) {
            return this.storageD[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayDouble {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public double get(int i, int j, int k, int l) {
            return this.storageD[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayDouble {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public double get(int i, int j, int k) {
            return this.storageD[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }

        public IF getIF() {
            return new IF();
        }

        static /* synthetic */ Index3D access$900(D3 x0) {
            return x0.ix;
        }

        public class IF {
            private int currElement = -1;
            private int size = (int)D3.access$900(D3.this).getSize();

            public boolean hasNext(int howMany) {
                return this.currElement < this.size - howMany;
            }

            public double getNext() {
                return D3.this.storageD[++this.currElement];
            }

            public void setNext(double val) {
                D3.this.storageD[++this.currElement] = val;
            }
        }
    }

    public static class D2
    extends ArrayDouble {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public double get(int i, int j) {
            return this.storageD[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, double value) {
            this.storageD[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayDouble {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public double get(int i) {
            return this.storageD[this.ix.setDirect(i)];
        }

        public void set(int i, double value) {
            this.storageD[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayDouble {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(IndexImpl i, double[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public double get() {
            return this.storageD[this.ix.currentElement()];
        }

        public void set(double value) {
            this.storageD[this.ix.currentElement()] = value;
        }
    }
}

