/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ArrayBoolean;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayShort;
import ucar.ma2.Index;
import ucar.ma2.IndexImpl;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;

public abstract class ArrayAbstract
implements Array,
Cloneable {
    protected final IndexImpl indexCalc;
    protected final int rank;

    public static ArrayAbstract factory(Class type, int[] shape) {
        IndexImpl index = IndexImpl.factory(shape);
        return ArrayAbstract.factory(type, index);
    }

    private static ArrayAbstract factory(Class type, IndexImpl index) {
        if (type == Double.TYPE) {
            return ArrayDouble.factory(index);
        }
        if (type == Float.TYPE) {
            return ArrayFloat.factory(index);
        }
        if (type == Long.TYPE) {
            return ArrayLong.factory(index);
        }
        if (type == Integer.TYPE) {
            return ArrayInt.factory(index);
        }
        if (type == Short.TYPE) {
            return ArrayShort.factory(index);
        }
        if (type == Byte.TYPE) {
            return ArrayByte.factory(index);
        }
        if (type == Character.TYPE) {
            return ArrayChar.factory(index);
        }
        if (type == Boolean.TYPE) {
            return ArrayBoolean.factory(index);
        }
        throw new UnsupportedOperationException("unsupported type = " + type);
    }

    public static ArrayAbstract factory(Class type, int[] shape, Object storage) {
        IndexImpl indexCalc = IndexImpl.factory(shape);
        if (type == Double.TYPE) {
            return ArrayDouble.factory(indexCalc, (double[])storage);
        }
        if (type == Float.TYPE) {
            return ArrayFloat.factory(indexCalc, (float[])storage);
        }
        if (type == Long.TYPE) {
            return ArrayLong.factory(indexCalc, (long[])storage);
        }
        if (type == Integer.TYPE) {
            return ArrayInt.factory(indexCalc, (int[])storage);
        }
        if (type == Short.TYPE) {
            return ArrayShort.factory(indexCalc, (short[])storage);
        }
        if (type == Byte.TYPE) {
            return ArrayByte.factory(indexCalc, (byte[])storage);
        }
        if (type == Character.TYPE) {
            return ArrayChar.factory(indexCalc, (char[])storage);
        }
        if (type == Boolean.TYPE) {
            return ArrayBoolean.factory(indexCalc, (boolean[])storage);
        }
        throw new UnsupportedOperationException();
    }

    public static ArrayAbstract factory(Object javaArray) {
        int rank_ = 0;
        Class<?> componentType = javaArray.getClass();
        while (componentType.isArray()) {
            ++rank_;
            componentType = componentType.getComponentType();
        }
        if (rank_ == 0) {
            throw new IllegalArgumentException("ArrayAbstract.factory: not an array");
        }
        if (!componentType.isPrimitive()) {
            throw new UnsupportedOperationException("ArrayAbstract.factory: not a primitive array");
        }
        int count = 0;
        int[] shape = new int[rank_];
        Object jArray = javaArray;
        Class<?> cType = jArray.getClass();
        while (cType.isArray()) {
            shape[count++] = java.lang.reflect.Array.getLength(jArray);
            jArray = java.lang.reflect.Array.get(jArray, 0);
            cType = jArray.getClass();
        }
        ArrayAbstract aa = ArrayAbstract.factory(componentType, shape);
        IndexIterator aaIter = aa.getIndexIterator();
        ArrayAbstract.reflectArrayCopyIn(javaArray, aa, aaIter);
        return aa;
    }

    private static void reflectArrayCopyIn(Object jArray, ArrayAbstract aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (cType.isPrimitive()) {
            aa.copyFrom1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                ArrayAbstract.reflectArrayCopyIn(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    private static void reflectArrayCopyOut(Object jArray, ArrayAbstract aa, IndexIterator aaIter) {
        Class<?> cType = jArray.getClass().getComponentType();
        if (cType.isPrimitive()) {
            aa.copyTo1DJavaArray(aaIter, jArray);
        } else {
            for (int i = 0; i < java.lang.reflect.Array.getLength(jArray); ++i) {
                ArrayAbstract.reflectArrayCopyOut(java.lang.reflect.Array.get(jArray, i), aa, aaIter);
            }
        }
    }

    public static void arraycopy(ArrayAbstract arraySrc, int srcPos, ArrayAbstract arrayDst, int dstPos, int len) {
        System.arraycopy(arraySrc.getStorage(), srcPos, arrayDst.getStorage(), dstPos, len);
    }

    protected ArrayAbstract(int[] shape) {
        this.rank = shape.length;
        this.indexCalc = IndexImpl.factory(shape);
    }

    protected ArrayAbstract(IndexImpl index) {
        this.rank = index.getRank();
        this.indexCalc = index;
    }

    public Index getIndex() {
        return (Index)this.indexCalc.clone();
    }

    public IndexIterator getIndexIterator() {
        return this.indexCalc.getIndexIterator(this);
    }

    public int getRank() {
        return this.rank;
    }

    public int[] getShape() {
        return this.indexCalc.getShape();
    }

    public long getSize() {
        return this.indexCalc.getSize();
    }

    public IndexIterator getRangeIterator(Range[] ranges) throws InvalidRangeException {
        return this.section(ranges).getIndexIterator();
    }

    public IndexIterator getIndexIteratorFast() {
        return this.indexCalc.getIndexIteratorFast(this);
    }

    public abstract Class getElementType();

    abstract ArrayAbstract createView(IndexImpl var1);

    public abstract Object getStorage();

    abstract void copyFrom1DJavaArray(IndexIterator var1, Object var2);

    abstract void copyTo1DJavaArray(IndexIterator var1, Object var2);

    public Array section(Range[] ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array section(int[] origin, int[] shape) throws InvalidRangeException {
        Range[] ranges = new Range[origin.length];
        for (int i = 0; i < origin.length; ++i) {
            ranges[i] = new Range(origin[i], origin[i] + shape[i] - 1);
        }
        return this.createView(this.indexCalc.section(ranges));
    }

    public Array sectionNoReduce(Range[] ranges) throws InvalidRangeException {
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array sectionNoReduce(int[] origin, int[] shape) throws InvalidRangeException {
        Range[] ranges = new Range[origin.length];
        for (int i = 0; i < origin.length; ++i) {
            ranges[i] = new Range(origin[i], origin[i] + shape[i] - 1);
        }
        return this.createView(this.indexCalc.sectionNoReduce(ranges));
    }

    public Array slice(int dim, int value) {
        int[] origin = new int[this.rank];
        int[] shape = this.getShape();
        origin[dim] = value;
        shape[dim] = 1;
        try {
            return this.sectionNoReduce(origin, shape).reduce(dim);
        }
        catch (InvalidRangeException e) {
            throw new IllegalArgumentException();
        }
    }

    public Array copy() {
        ArrayAbstract newA = ArrayAbstract.factory(this.getElementType(), this.getShape());
        MAMath.copy(newA, this);
        return newA;
    }

    public Object copyTo1DJavaArray() {
        ArrayAbstract newA = (ArrayAbstract)this.copy();
        return newA.getStorage();
    }

    public Object copyToNDJavaArray() {
        Object javaArray;
        try {
            javaArray = java.lang.reflect.Array.newInstance(this.getElementType(), this.getShape());
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        IndexIterator iter = this.getIndexIterator();
        ArrayAbstract.reflectArrayCopyOut(javaArray, this, iter);
        return javaArray;
    }

    public Array flip(int dim) {
        return this.createView(this.indexCalc.flip(dim));
    }

    public Array transpose(int dim1, int dim2) {
        return this.createView(this.indexCalc.transpose(dim1, dim2));
    }

    public Array permute(int[] dims) {
        return this.createView(this.indexCalc.permute(dims));
    }

    public Array reshape(int[] shape) {
        ArrayAbstract result = ArrayAbstract.factory(this.getElementType(), shape);
        if (result.getSize() != this.getSize()) {
            throw new IllegalArgumentException("reshape arrays must have same total size");
        }
        ArrayAbstract.arraycopy(this, 0, result, 0, (int)this.getSize());
        return result;
    }

    public Array reduce() {
        return this.createView(this.indexCalc.reduce());
    }

    public Array reduce(int dim) {
        return this.createView(this.indexCalc.reduce(dim));
    }

    public Array read(int[] origin, int[] shape) throws InvalidRangeException {
        return this.sectionNoReduce(origin, shape);
    }

    public Array read() {
        return this;
    }

    public abstract Object getObject(Index var1);

    public abstract void setObject(Index var1, Object var2);

    abstract double getDouble(int var1);

    abstract void setDouble(int var1, double var2);

    abstract float getFloat(int var1);

    abstract void setFloat(int var1, float var2);

    abstract long getLong(int var1);

    abstract void setLong(int var1, long var2);

    abstract int getInt(int var1);

    abstract void setInt(int var1, int var2);

    abstract short getShort(int var1);

    abstract void setShort(int var1, short var2);

    abstract byte getByte(int var1);

    abstract void setByte(int var1, byte var2);

    abstract char getChar(int var1);

    abstract void setChar(int var1, char var2);

    abstract boolean getBoolean(int var1);

    abstract void setBoolean(int var1, boolean var2);

    abstract Object getObject(int var1);
}

