/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayAbstract;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.DataType;
import ucar.nc2.Variable;

public class VariableStandardized
extends Variable {
    private static float feps = 1.0f;
    private static double deps;
    private Variable orgVar;
    private boolean useNaNs;
    private boolean hasScaleOffset = false;
    private double scale = 1.0;
    private double offset = 0.0;
    private boolean hasValidRange = false;
    private boolean hasValidMin = false;
    private boolean hasValidMax = false;
    private boolean hasInvalidData = false;
    private double valid_min = Double.MIN_VALUE;
    private double valid_max = Double.MAX_VALUE;
    private boolean hasFillValue = false;
    private double fillValue;
    private boolean hasMissingValue = false;
    private double[] missingValue;
    private boolean invalidDataIsMissing;
    private boolean fillValueIsMissing;
    private boolean missingDataIsMissing;
    private boolean debug = false;
    private boolean debugRead = false;
    private String desc;
    private String units;

    public VariableStandardized(Variable orgVar) {
        this(orgVar, true);
    }

    public VariableStandardized(Variable orgVar, boolean useNaNs) {
        this(orgVar, useNaNs, true, true, true);
    }

    public VariableStandardized(Variable orgVar, boolean useNaNs, boolean fillValueIsMissing, boolean invalidDataIsMissing, boolean missingDataIsMissing) {
        super(orgVar.getName());
        Attribute att;
        this.shape = orgVar.getShape();
        this.dimensions = new ArrayList(orgVar.getDimensions());
        this.attributes = new ArrayList(orgVar.getAttributes());
        this.isCoordinateVariable = orgVar.isCoordinateVariable();
        this.orgVar = orgVar;
        this.useNaNs = useNaNs;
        this.fillValueIsMissing = fillValueIsMissing;
        this.invalidDataIsMissing = invalidDataIsMissing;
        this.missingDataIsMissing = missingDataIsMissing;
        DataType scaleType = null;
        DataType missType = null;
        DataType validType = null;
        DataType fillType = null;
        if (this.debug) {
            System.out.println("VariableStandardized = " + orgVar.getName());
        }
        if (null != (att = orgVar.findAttribute("scale_factor")) && !att.isString()) {
            this.scale = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            scaleType = DataType.getType(att.getValueType());
            if (this.debug) {
                System.out.println("scale = " + this.scale + " type " + scaleType);
            }
        }
        if (null != (att = orgVar.findAttribute("add_offset")) && !att.isString()) {
            this.offset = att.getNumericValue().doubleValue();
            this.hasScaleOffset = true;
            DataType offType = DataType.getType(att.getValueType());
            if (this.rank(offType) > this.rank(scaleType)) {
                scaleType = offType;
            }
            if (this.debug) {
                System.out.println("offset = " + this.offset);
            }
        }
        if (null != (att = orgVar.findAttribute("valid_range")) && !att.isString() && att.isArray()) {
            this.valid_min = att.getNumericValue(0).doubleValue();
            this.valid_max = att.getNumericValue(1).doubleValue();
            this.hasValidRange = true;
            validType = DataType.getType(att.getValueType());
            if (this.debug) {
                System.out.println("valid_range = " + this.valid_min + " " + this.valid_max);
            }
        }
        if (!this.hasValidRange) {
            att = orgVar.findAttribute("valid_min");
            if (null != att && !att.isString()) {
                this.valid_min = att.getNumericValue().doubleValue();
                this.hasValidMin = true;
                validType = DataType.getType(att.getValueType());
                if (this.debug) {
                    System.out.println("valid_min = " + this.valid_min);
                }
            }
            if (null != (att = orgVar.findAttribute("valid_max")) && !att.isString()) {
                this.valid_max = att.getNumericValue().doubleValue();
                this.hasValidMax = true;
                DataType t = DataType.getType(att.getValueType());
                if (this.rank(t) > this.rank(validType)) {
                    validType = t;
                }
                if (this.debug) {
                    System.out.println("valid_min = " + this.valid_max);
                }
            }
            if (this.hasValidMin && this.hasValidMax) {
                this.hasValidRange = true;
            }
        }
        boolean hasValidData = this.hasValidMin || this.hasValidMax || this.hasValidRange;
        att = orgVar.findAttribute("_FillValue");
        if (null != att && !att.isString()) {
            this.fillValue = att.getNumericValue().doubleValue();
            this.hasFillValue = true;
            fillType = DataType.getType(att.getValueType());
            if (this.debug) {
                System.out.println("missing_datum from _FillValue = " + this.fillValue);
            }
        }
        if (null != (att = orgVar.findAttribute("missing_value")) && !att.isString()) {
            if (!att.isArray()) {
                this.missingValue = new double[1];
                this.missingValue[0] = att.getNumericValue().doubleValue();
                if (this.debug) {
                    System.out.println("missing_datum = " + this.missingValue[0]);
                }
            } else {
                int n = att.getLength();
                this.missingValue = new double[n];
                if (this.debug) {
                    System.out.print("missing_data = ");
                }
                for (int i = 0; i < n; ++i) {
                    this.missingValue[i] = att.getNumericValue(i).doubleValue();
                    if (!this.debug) continue;
                    System.out.print(" " + this.missingValue[i]);
                }
                if (this.debug) {
                    System.out.println();
                }
            }
            missType = DataType.getType(att.getValueType());
            this.hasMissingValue = true;
        }
        boolean hasMissing = invalidDataIsMissing && hasValidData || fillValueIsMissing && this.hasFillValue || missingDataIsMissing && this.hasMissingValue;
        DataType dataType = orgVar.getDataType();
        if (this.hasScaleOffset) {
            if (hasMissing) {
                if (this.rank(scaleType) > this.rank(dataType)) {
                    dataType = scaleType;
                }
                if (missingDataIsMissing && this.rank(missType) > this.rank(dataType)) {
                    dataType = missType;
                }
                if (fillValueIsMissing && this.rank(fillType) > this.rank(dataType)) {
                    dataType = fillType;
                }
                if (invalidDataIsMissing && this.rank(validType) > this.rank(dataType)) {
                    dataType = validType;
                }
                if (this.rank(dataType) < this.rank(DataType.DOUBLE)) {
                    dataType = DataType.FLOAT;
                }
            } else if (this.rank(scaleType) > this.rank(dataType)) {
                dataType = scaleType;
            }
        }
        this.elementType = dataType.getPrimitiveClassType();
        if (this.debug) {
            System.out.println("assign elemType = " + this.elementType);
        }
        if (this.hasScaleOffset) {
            if (this.hasFillValue) {
                this.fillValue = this.scale * this.fillValue + this.offset;
                if (this.debug) {
                    System.out.println("scale the fillValue");
                }
            }
            if (this.hasMissingValue) {
                for (int i = 0; i < this.missingValue.length; ++i) {
                    this.missingValue[i] = this.scale * this.missingValue[i] + this.offset;
                }
                if (this.debug) {
                    System.out.println("scale the missing values");
                }
            }
            if (hasValidData) {
                DataType orgType = orgVar.getDataType();
                if (this.rank(validType) != this.rank(scaleType) || this.rank(scaleType) <= this.rank(orgType)) {
                    if (this.hasValidRange || this.hasValidMin) {
                        this.valid_min = this.scale * this.valid_min + this.offset;
                    }
                    if (this.hasValidRange || this.hasValidMax) {
                        this.valid_max = this.scale * this.valid_max + this.offset;
                    }
                    if (this.debug) {
                        System.out.println("scale the range");
                    }
                }
            }
        }
        boolean bl = useNaNs = useNaNs && (this.elementType == Double.TYPE || this.elementType == Float.TYPE);
        if (this.debug) {
            System.out.println("useNaNs = " + useNaNs);
        }
    }

    private int rank(DataType c) {
        if (c == DataType.BYTE) {
            return 0;
        }
        if (c == DataType.SHORT) {
            return 1;
        }
        if (c == DataType.INT) {
            return 2;
        }
        if (c == DataType.LONG) {
            return 3;
        }
        if (c == DataType.FLOAT) {
            return 4;
        }
        if (c == DataType.DOUBLE) {
            return 5;
        }
        return -1;
    }

    public boolean hasInvalidData() {
        return this.hasValidRange || this.hasValidMin || this.hasValidMax;
    }

    public double getValidMin() {
        return this.valid_min;
    }

    public double getValidMax() {
        return this.valid_max;
    }

    public boolean isInvalidData(double val) {
        if (this.hasValidRange) {
            return val < this.valid_min || val > this.valid_max;
        }
        if (this.hasValidMin) {
            return val < this.valid_min;
        }
        if (this.hasValidMax) {
            return val > this.valid_max;
        }
        return false;
    }

    public boolean hasFillValue() {
        return this.hasFillValue;
    }

    public boolean isFillValue(double val) {
        return this.hasFillValue && this.isClose(val, this.fillValue);
    }

    public boolean hasScaleOffset() {
        return this.hasScaleOffset;
    }

    public boolean hasMissingValue() {
        return this.hasMissingValue;
    }

    public boolean isMissingValue(double val) {
        if (!this.hasMissingValue) {
            return false;
        }
        for (int i = 0; i < this.missingValue.length; ++i) {
            if (!this.isClose(val, this.missingValue[i])) continue;
            return true;
        }
        return false;
    }

    public void setFillValueIsMissing(boolean b) {
        this.fillValueIsMissing = b;
    }

    public void setInvalidDataIsMissing(boolean b) {
        this.invalidDataIsMissing = b;
    }

    public void setMissingDataIsMissing(boolean b) {
        this.missingDataIsMissing = b;
    }

    public boolean hasMissing() {
        return this.invalidDataIsMissing && this.hasInvalidData() || this.fillValueIsMissing && this.hasFillValue() || this.missingDataIsMissing && this.hasMissingValue();
    }

    public boolean isMissing(double val) {
        if (Double.isNaN(val)) {
            return true;
        }
        if (!this.hasMissing()) {
            return false;
        }
        return this.invalidDataIsMissing && this.isInvalidData(val) || this.fillValueIsMissing && this.isFillValue(val) || this.missingDataIsMissing && this.isMissingValue(val);
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDescription() {
        if (this.desc == null) {
            Attribute att = this.findAttributeIgnoreCase("long_name");
            if (att != null && att.isString()) {
                this.desc = att.getStringValue();
            }
            if (this.desc == null && (att = this.findAttributeIgnoreCase("description")) != null && att.isString()) {
                this.desc = att.getStringValue();
            }
            if (this.desc == null) {
                this.desc = this.name;
            }
        }
        return this.desc;
    }

    public void setUnitString(String units) {
        this.units = units;
    }

    public String getUnitString() {
        Attribute att;
        if (this.units == null && (att = this.findAttributeIgnoreCase("units")) != null && att.isString()) {
            this.units = att.getStringValue();
        }
        return this.units;
    }

    public Array read(int[] origin, int[] shape) throws IOException, InvalidRangeException {
        if (this.debugRead) {
            System.out.println("read (shape) ");
        }
        ArrayAbstract result = (ArrayAbstract)this.orgVar.read(origin, shape);
        if (this.useNaNs) {
            result = this.convertToNaNs(result);
        } else if (this.hasScaleOffset) {
            result = this.convertScaleOffset(result);
        }
        return result;
    }

    public Array read() throws IOException {
        if (this.debugRead) {
            System.out.println("read ");
        }
        ArrayAbstract result = (ArrayAbstract)this.orgVar.read();
        if (this.useNaNs) {
            result = this.convertToNaNs(result);
        } else if (this.hasScaleOffset) {
            result = this.convertScaleOffset(result);
        }
        return result;
    }

    private ArrayAbstract convertScaleOffset(ArrayAbstract in) {
        ArrayAbstract out = ArrayAbstract.factory(this.getElementType(), in.getShape());
        IndexIterator iterIn = in.getIndexIteratorFast();
        IndexIterator iterOut = out.getIndexIteratorFast();
        if (this.debugRead) {
            System.out.println("convertScaleOffset ");
        }
        while (iterIn.hasNext()) {
            double val = iterIn.getDoubleNext();
            iterOut.setDoubleNext(this.scale * val + this.offset);
        }
        return out;
    }

    private ArrayAbstract convertToNaNs(ArrayAbstract in) {
        ArrayAbstract out = ArrayAbstract.factory(this.getElementType(), in.getShape());
        IndexIterator iterIn = in.getIndexIteratorFast();
        IndexIterator iterOut = out.getIndexIteratorFast();
        if (this.debugRead) {
            System.out.println("convertToNaNs ");
        }
        while (iterIn.hasNext()) {
            double val = this.scale * iterIn.getDoubleNext() + this.offset;
            iterOut.setDoubleNext(this.isMissing(val) ? Double.NaN : val);
        }
        return out;
    }

    public float[] setMissingToNaN(float[] values) {
        if (!this.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            float value = values[i];
            if (!(this.invalidDataIsMissing && this.isInvalidData(value) || this.fillValueIsMissing && this.isFillValue(value)) && (!this.missingDataIsMissing || !this.isMissingValue(value))) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public String toStringN() {
        return this.orgVar.toStringN();
    }

    private boolean isClose(double d1, double d2) {
        if (d1 > 0.0 != d2 > 0.0) {
            return false;
        }
        if (this.elementType == Double.TYPE) {
            return Math.abs(d1 - d2) <= Math.abs(deps * d2);
        }
        return Math.abs(d1 - d2) <= Math.abs((double)feps * d2);
    }

    static {
        while (feps + 1.0f != 1.0f) {
            feps /= 2.0f;
        }
        feps *= 2.0f;
        deps = 1.0;
        while (deps + 1.0 != 1.0) {
            deps /= 2.0;
        }
        deps *= 2.0;
    }
}

