/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.ma2.ArrayAbstract;
import ucar.nc2.ArrayAdapter2;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.netcdf.Attribute;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;

public class NetcdfFileWriteable
extends NetcdfFile {
    private Schema schema;
    private HashMap protoVarHash = new HashMap(50);
    private boolean defineMode;
    private boolean fill = false;
    private ArrayList variables = null;
    private ArrayList dimensions = null;
    private ArrayList gattributes = null;

    public NetcdfFileWriteable() {
        this.schema = new Schema();
        this.defineMode = true;
    }

    public NetcdfFileWriteable(String filename) throws IOException {
        super(filename, false);
        this.defineMode = false;
    }

    public void setName(String filename) {
        this.name = filename;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        if (!this.defineMode) {
            this.ncfile.setFill(fill);
        }
    }

    public Dimension addDimension(String dimName, int size) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (size < 0) {
            return new Dimension(new UnlimitedDimension(dimName));
        }
        return new Dimension(new ucar.netcdf.Dimension(dimName, size));
    }

    public void addGlobalAttribute(String name, String value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute attr = new Attribute(name, value);
        this.schema.putAttribute(attr);
    }

    public void addGlobalAttribute(String name, Number value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute attr = new Attribute(name, value);
        this.schema.putAttribute(attr);
    }

    public void addGlobalAttribute(String name, Object value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute attr = new Attribute(name, value);
        this.schema.putAttribute(attr);
    }

    public void addVariable(String varName, Class componentType, Dimension[] dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        ucar.netcdf.Dimension[] d = new ucar.netcdf.Dimension[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            d[i] = dims[i].getOrg();
        }
        ProtoVariable proto = new ProtoVariable(varName, componentType, d);
        this.schema.put(proto);
        this.protoVarHash.put(varName, proto);
    }

    public void addVariableAttribute(String varName, String attName, String value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        ProtoVariable proto = (ProtoVariable)this.protoVarHash.get(varName);
        if (null == proto) {
            throw new IllegalArgumentException("addVariableAttribute variable name not found = <" + varName + ">");
        }
        Attribute attr = new Attribute(attName, value);
        proto.putAttribute(attr);
    }

    public void addVariableAttribute(String varName, String attName, Number value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        ProtoVariable proto = (ProtoVariable)this.protoVarHash.get(varName);
        if (null == proto) {
            throw new IllegalArgumentException("addVariableAttribute illegal variable name " + varName);
        }
        Attribute attr = new Attribute(attName, value);
        proto.putAttribute(attr);
    }

    public void addVariableAttribute(String varName, String attName, Object value) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        ProtoVariable proto = (ProtoVariable)this.protoVarHash.get(varName);
        if (null == proto) {
            throw new IllegalArgumentException("addVariableAttribute illegal variable name " + varName);
        }
        Attribute attr = new Attribute(attName, value);
        proto.putAttribute(attr);
    }

    public void create() throws IOException {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.ncfile = new ucar.netcdf.NetcdfFile(this.name, true, this.fill, this.schema);
        if (this.ncfile == null) {
            throw new IOException("createNetcdfFile failed");
        }
        this.init(this.ncfile);
        this.defineMode = false;
    }

    public boolean write(String varName, ArrayAbstract values) throws IOException {
        int[] origin = new int[values.getRank()];
        return this.write(varName, origin, values);
    }

    public boolean write(String varName, int[] origin, ArrayAbstract values) throws IOException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        Variable ncvar = this.findVariable(varName);
        if (ncvar == null) {
            throw new IllegalArgumentException("NetcdfFileWriteable.write illegal variable name " + varName);
        }
        ucar.netcdf.Variable realvar = ncvar.getNetcdfVariable();
        ArrayAdapter2 aa = new ArrayAdapter2(values);
        realvar.copyin(origin, aa);
        return true;
    }

    public void flush() throws IOException {
        this.ncfile.flush();
    }

    boolean write(ucar.netcdf.Variable ncvar, int[] origin, ArrayAbstract values) throws IOException {
        ArrayAdapter2 aa = new ArrayAdapter2(values);
        ncvar.copyin(origin, aa);
        return true;
    }

    ucar.netcdf.Variable getVarByName(String name) {
        Variable ncvar = this.findVariable(name);
        if (ncvar == null) {
            return null;
        }
        return ncvar.getNetcdfVariable();
    }
}

