/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class NCdump {
    private static boolean debugSlice = false;
    private static boolean debugSelector = false;
    private static String usage = "usage: NCdump <filename> [-ncml] [-c | -vall] [-v varName1;varName2,..] [-v varName(0:1,*,12)]\n";

    public static boolean printHeader(String fileName, OutputStream out) throws IOException {
        return NCdump.print(fileName, out, false, false, false, null);
    }

    public static boolean printNcML(String fileName, OutputStream out) throws IOException {
        return NCdump.print(fileName, out, false, true, true, null);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean print(String command, OutputStream out) throws IOException {
        void var2_7;
        boolean showAll = false;
        boolean showCoords = false;
        boolean ncml = false;
        String varNames = null;
        StringTokenizer stoke = new StringTokenizer(command);
        if (stoke.hasMoreTokens()) {
            String filename = stoke.nextToken();
        } else {
            out.write(usage.getBytes());
            return false;
        }
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("-vall")) {
                showAll = true;
            }
            if (toke.equalsIgnoreCase("-c")) {
                showCoords = true;
            }
            if (toke.equalsIgnoreCase("-ncml")) {
                ncml = true;
            }
            if (!toke.equalsIgnoreCase("-v") || !stoke.hasMoreTokens()) continue;
            varNames = stoke.nextToken();
        }
        return NCdump.print((String)var2_7, out, showAll, showCoords, ncml, varNames);
    }

    public static boolean print(NetcdfFile nc, String command, OutputStream out) throws IOException {
        boolean showAll = false;
        boolean showCoords = false;
        boolean ncml = false;
        String varNames = null;
        StringTokenizer stoke = new StringTokenizer(command);
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken();
            if (toke.equalsIgnoreCase("-help")) {
                out.write(usage.getBytes());
                out.write(10);
                return true;
            }
            if (toke.equalsIgnoreCase("-vall")) {
                showAll = true;
            }
            if (toke.equalsIgnoreCase("-c")) {
                showCoords = true;
            }
            if (toke.equalsIgnoreCase("-ncml")) {
                ncml = true;
            }
            if (!toke.equalsIgnoreCase("-v") || !stoke.hasMoreTokens()) continue;
            varNames = stoke.nextToken();
        }
        return NCdump.print(nc, out, showAll, showCoords, ncml, varNames);
    }

    public static boolean print(String fileName, OutputStream out, boolean showAll, boolean showCoords, boolean ncml, String varNames) throws IOException {
        NetcdfFile nc = null;
        try {
            nc = new NetcdfFile(fileName);
        }
        catch (FileNotFoundException e) {
            String mess = "file not found= " + fileName;
            out.write(mess.getBytes());
            return false;
        }
        return NCdump.print(nc, out, showAll, showCoords, ncml, varNames);
    }

    public static boolean print(NetcdfFile nc, OutputStream out, boolean showAll, boolean showCoords, boolean ncml, String varNames) throws IOException {
        block13: {
            boolean headerOnly = !showAll && varNames == null;
            try {
                Variable v;
                Iterator vi;
                if (ncml) {
                    nc.writeNcML(out, showCoords, null);
                    break block13;
                }
                if (headerOnly) {
                    nc.writeCDL(out);
                    break block13;
                }
                PrintStream ps = new PrintStream(out);
                nc.toStringStart(ps);
                ps.print(" data:\n");
                if (showAll) {
                    vi = nc.getVariableIterator();
                    while (vi.hasNext()) {
                        v = (Variable)vi.next();
                        NCdump.printArray(ps, v.getName(), v.read());
                    }
                } else if (showCoords) {
                    vi = nc.getVariableIterator();
                    while (vi.hasNext()) {
                        v = (Variable)vi.next();
                        if (!v.isCoordinateVariable()) continue;
                        NCdump.printArray(ps, v.getName(), v.read());
                    }
                }
                if (!showAll && varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0 && varSubset.indexOf(41) >= 0) {
                            Array data = NCdump.parseVarSelector(nc, ps, varSubset);
                            if (data == null) continue;
                            NCdump.printArray(ps, varSubset, data);
                            continue;
                        }
                        Variable v2 = nc.findVariable(varSubset);
                        if (v2 == null) {
                            ps.print(" cant find variable: " + varSubset + "\n" + usage);
                            continue;
                        }
                        if (showCoords && v2.isCoordinateVariable()) continue;
                        NCdump.printArray(ps, v2.getName(), v2.read());
                    }
                }
                nc.toStringEnd(ps);
                ps.flush();
            }
            catch (Exception e) {
                out.write(e.getMessage().getBytes());
                return false;
            }
        }
        return true;
    }

    private static Array parseVarSelector(NetcdfFile nc, PrintStream ps, String token) {
        try {
            ArrayList result = NCdump.parseVarSelector(nc, token);
            String varName = (String)result.get(0);
            Variable v = nc.findVariable(varName);
            if (v == null) {
                ps.print(" ERROR: Unknown Variable name = <" + varName + ">\n");
                return null;
            }
            if (result.size() < 3) {
                return v.read();
            }
            int[] origin = (int[])result.get(1);
            int[] shape = (int[])result.get(2);
            return v.read(origin, shape);
        }
        catch (Exception e) {
            ps.print(" ERROR: " + e.getMessage() + "\n" + usage);
            e.printStackTrace();
            return null;
        }
    }

    private static ArrayList parseVarSelector(NetcdfFile ncfile, String token) {
        ArrayList<String> result = new ArrayList<String>();
        int pos1 = token.indexOf(40);
        int pos2 = token.indexOf(41);
        if (pos1 < 0 && pos2 < 0) {
            result.add(token);
            return result;
        }
        if (pos1 < 0 || pos2 < 0 || pos1 > pos2) {
            throw new IllegalArgumentException("mismatched brackets = " + token);
        }
        String varName = token.substring(0, pos1);
        result.add(varName);
        Variable v = ncfile.findVariable(varName);
        if (v == null) {
            throw new IllegalArgumentException(" cant find variable: " + varName + " part of " + token);
        }
        String select = token.substring(pos1 + 1, pos2);
        result.addAll(NCdump.parseVarSelector(v, select));
        return result;
    }

    public static ArrayList parseVarSelector(Variable v, String select) {
        int rank = v.getRank();
        int[] origin = new int[rank];
        int[] len = v.getShape();
        int pos = 0;
        int count = 0;
        StringTokenizer stoke = new StringTokenizer(select, ",");
        while (stoke.hasMoreTokens()) {
            String s = stoke.nextToken();
            if (!s.equals("*")) {
                pos = s.indexOf(58);
                if (pos > 0) {
                    String s1 = s.substring(0, pos);
                    String s2 = s.substring(pos + 1);
                    try {
                        int index1 = Integer.parseInt(s1);
                        int index2 = Integer.parseInt(s2);
                        origin[count] = index1;
                        len[count] = index2 - index1 + 1;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + select + ">");
                    }
                }
                try {
                    int index;
                    origin[count] = index = Integer.parseInt(s);
                    len[count] = 1;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(" illegal selector: " + s + " part of <" + select + ">");
                }
            }
            ++count;
        }
        if (count != rank) {
            throw new IllegalArgumentException(" number of selectors != rank: <" + select + ">");
        }
        if (debugSelector) {
            for (int i = 0; i < origin.length; ++i) {
                System.out.println(" start=" + origin[i] + " count= " + len[i]);
            }
        }
        ArrayList<int[]> result = new ArrayList<int[]>();
        result.add(origin);
        result.add(len);
        return result;
    }

    public static void printArray(PrintStream out, String header, Array array) {
        out.print("  " + header + " =");
        IndentLevel ilev = new IndentLevel(2);
        ilev.incr();
        ilev.incr();
        if (array instanceof ArrayChar && array.getRank() > 0) {
            NCdump.printStringArray(out, (ArrayChar)array, ilev);
        } else {
            NCdump.printArray(out, array, ilev);
        }
        out.print("\n");
    }

    private static void printArray(PrintStream out, Array ma, IndentLevel ilev) {
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print(ma.getObject(ima).toString());
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + ilev.getIndent() + "{");
        if (rank == 1) {
            for (int ii = 0; ii < last; ++ii) {
                out.print(ma.getObject(ima.set(ii)).toString());
                if (ii == last - 1) continue;
                out.print(", ");
            }
            out.print("}");
            return;
        }
        ilev.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            NCdump.printArray(out, slice, ilev);
            if (ii == last - 1) continue;
            out.print(",");
        }
        ilev.decr();
        out.print("\n" + ilev.getIndent() + "}");
    }

    private static void printStringArray(PrintStream out, ArrayChar ma, IndentLevel ilev) {
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 1) {
            out.print(ma.getString());
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + ilev.getIndent() + "{");
        ilev.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            NCdump.printStringArray(out, slice, ilev);
            if (ii == last - 1) continue;
            out.print(",");
        }
        ilev.decr();
        out.print("\n" + ilev.getIndent() + "}");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        String filename = args[0];
        boolean showAll = false;
        boolean showCoords = false;
        boolean ncml = false;
        String varNames = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-vall")) {
                showAll = true;
            }
            if (args[i].equalsIgnoreCase("-c")) {
                showCoords = true;
            }
            if (args[i].equalsIgnoreCase("-ncml")) {
                ncml = true;
            }
            if (!args[i].equalsIgnoreCase("-v") || i >= args.length - 1) continue;
            varNames = args[++i];
        }
        try {
            NCdump.print(filename, (OutputStream)System.out, showAll, showCoords, ncml, varNames);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static class IndentLevel {
        private int level = 0;
        private int indentation;
        private StringBuffer indent;
        private StringBuffer blanks;

        public IndentLevel(int indentation) {
            if (indentation > 0) {
                this.indentation = indentation;
            }
            this.indent = new StringBuffer();
            this.blanks = new StringBuffer();
            for (int i = 0; i < indentation; ++i) {
                this.blanks.append(" ");
            }
        }

        public void incr() {
            this.level += this.indentation;
            this.indent.append(this.blanks);
        }

        public void decr() {
            this.level -= this.indentation;
            this.indent.setLength(this.level);
        }

        public String getIndent() {
            return this.indent.toString();
        }
    }
}

