package org.mbari.util;

public class OceanUtil {

    private OceanUtil() {
    }

    /**
     * Calculate ocean depth from measured pressure and latitude.<br>
     *
     * Example: depth_(5000,36) -> 4906.08<br>
     *           depth_(1000,90) -> 9674.23  UNESCO 44 p28<br><br>
     *
     * Note:    For more accurate results an additional factor of the
     *          ratio of the actual geopotential anomaly/gravity must
     *          be added. This correction will be less than 2 m.<br>
     *
     * @param pressure dbar
     * @param latitude decimal degrees
     * @return
     */
    public static double pressureToDepth(double pressure, double latitude) {
        double C1 =  9.72659;
        double C2 = -2.2512E-5;
        double C3 =  2.279E-10;
        double C4 = -1.82E-15;

        double G0 = 9.780318;
        double G1 = 5.2788E-3;
        double G2 = 2.36E-5;

        double GAMMA = 2.184E-6;

        double X = Math.pow(Math.sin(Math.PI*latitude/180D), 2D);
        double GRAVITY = G0*(1.0D + (G1 + G2*X)*X) + (GAMMA/2D)*pressure;
        double Z = (C1 + (C2 + (C3 + C4*pressure)*pressure)*pressure)*pressure;
        return Z/GRAVITY;

    }
}