
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version 1.0
 */
package org.mbari.util;

import org.mbari.hobilabs.*;

public class HRUtil {

   private HRUtil() {
      // Don't allow instantiation
   }

   public static double[] calcWavelength(HRPacket p, double[] W) {
      return calcWavelength(p.FirstPix, p.PixInc, p.PixCount, W);
   }

   public static double[] calcWavelength(double firstPix, double pixInc, double pixCount,
    double[] W) {

      double[] lambda = new double[(int) pixCount];

      double pixelNum;
      for (int i = 0; i < pixCount; i++) {
         pixelNum = firstPix + pixInc*i;
         lambda[i] = W[0] + W[1] * pixelNum + W[2] * pixelNum * pixelNum;
      }

      return lambda;
   }
}