package org.mbari.test;

/**
 * Title:        MBARI general use classes
 * Description:  Classes for data processing and handliling at MBARI
 * Copyright:    Copyright (c) 2001
 * Company:      MBARI
 * @author Brian Schlining
 * @version 1.0
 */

import org.mbari.model.solar.*;
import java.util.*;
public class TestModel {

	public static void main(String[] args) {

		double[] lambda = new double[]{412, 443, 490, 510, 555};
		FrouinIrradianceModel fim = new FrouinIrradianceModel(lambda);
		double[] out = fim.calcIrradiance(new Date().getTime(), 0, -155);
		for(int i = 0; i < out.length; i++) {
			System.out.println("Radiance at " + lambda[i] + "nm is " + out[i]);
		}

	}

}