package org.mbari.test;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.mbari.awt.layout.*;

public class TestFrame2 extends JFrame {
    JPanel contentPane;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JButton btnPressMe = new JButton();
    JButton btnExit = new JButton();
    JLabel label = new JLabel();

    /**Construct the frame*/
    public TestFrame2() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    /**Component initialization*/
    private void jbInit() throws Exception  {
        //setIconImage(Toolkit.getDefaultToolkit().createImage(TestFrame2.class.getResource("[Your Icon]")));
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(verticalFlowLayout1);
        this.setSize(new Dimension(275, 133));
        this.setTitle("Hello World");
        btnPressMe.setText("Press Me");
        btnPressMe.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnPressMe_actionPerformed(e);
            }
        });
        btnExit.setText("Exit");
        btnExit.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                btnExit_mouseClicked(e);
            }
        });
        contentPane.add(jPanel1, null);
        jPanel1.add(btnPressMe, null);
        jPanel1.add(btnExit, null);
        contentPane.add(jPanel2, null);
        jPanel2.add(label, null);
    }
    /**Overridden so we can exit when window is closed*/
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            System.exit(0);
        }
    }

    void btnExit_mouseClicked(MouseEvent e) {
        System.exit(0);
    }

    void btnPressMe_actionPerformed(ActionEvent e) {
        label.setText("Hello World");
    }
}