package org.mbari.test;

/**
 * Title:        MBARI Java development
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      MBARI
 * @author Brian Schlining
 * @version 1.0
 */

import java.lang.reflect.*;
import java.util.Iterator;

public class RunUnitTests {

    public static void require(boolean requirement, String errmsg) {
        if (!requirement) {
            System.err.println(errmsg);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        require(args.length == 1, "Usage: RunUnitTests <qualified-class>");

        try {

            Class c = Class.forName(args[0]);

            // Only finds the inner classes declared int he current class
            Class[] classes = c.getDeclaredClasses();
            Class ut = null;

            for (int i = 0; i < classes.length; i++) {
                // Skip inner classes that are not dreived from UnitTest
                if (!UnitTest.class.isAssignableFrom(classes[i])) {
                    continue;
                }
                ut = classes[i];
                break; // Finds the first test class only
            }

            // If it found an inner class that class must be static
            if (ut != null) {
                require(Modifier.isStatic(ut.getModifiers()),
                    "inner UnitTest must be static");
            }

            // If it couldn't find the inner class maybe its a regular class
            // (for black-box testing)
            if (ut == null) {

                if (UnitTest.class.isAssignableFrom(c)) {
                    ut = c;
                }
            }

            require(ut != null, "No UnitTest class found");
            require(Modifier.isPublic(ut.getModifiers()),
                "UnitTest class must be public");
            Method[] methods = ut.getDeclaredMethods();

            for (int i = 0; i < methods.length; i++) {
                Method m = methods[i];
                // Ignore overridden UnitTest methods
                if (m.getName().equals("cleanup")) {
                    continue;
                }

                // Only public methdos with no arguments and vod return
                // types will be used to test code
                if (m.getParameterTypes().length == 0 &&
                    m.getReturnType() == void.class &&
                    Modifier.isPublic(m.getModifiers())) {

                    // The name of the test is used in error messages
                    UnitTest.testID = m.getName();

                    // A new instance of the test object is created and
                    // cleaned up for each test
                    Object test = ut.newInstance();
                    m.invoke(test, new Object[0]);
                    ((UnitTest)test).cleanup();

                }
            }

        } catch (Exception e) {
            e.printStackTrace(System.err);
            // Any exception will return a non-zero value to the console, so that
            // 'make' will abort
            System.exit(1);
        }

        // After all test in this class are run, display any results. If there
        // were error, abort 'make' by returnin a nonzero value.

        if (UnitTest.errors.size() != 0) {
            Iterator it = UnitTest.errors.iterator();
            while(it.hasNext()) {
                System.err.println(it.next());
            }
            System.exit(1);
        }

    }
}