package org.mbari.test;

import java.awt.*;
import java.awt.event.*;
import java.rmi.RemoteException;
import javax.swing.*;
import visad.*;
import visad.java2d.DisplayImplJ2D;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:
 * @author
 * @version 1.0
 */

public class PointVis2 implements IPointListener {

    public PointVis2() throws VisADException, RemoteException {
        this(5);
    }


    public PointVis2(int trailLength) throws VisADException, RemoteException {

        // Set the length of the trail
        points = new Point[trailLength];

        posX = new RealType("X");
        posY = new RealType("Y");
        index = new RealType("index");

        ////////////////////////////////////////////////////////////////////////
        // Code for setting the Point display

        // Organize posX and posY in a Tuple
        xyTuple = new RealTupleType(posX, posY);

        // Create a FunctionType ( index -> ( posX, posY) ), for points
        // Use FunctionType(MathType domain, MathType range)
        indexFunc = new FunctionType(index, xyTuple);

        // Index set is just a series of integers
        indexSet = new Integer1DSet(index, trailLength);

        // Create a FlatField, that is the Data class for the samples
        // Use FlatField(FunctionType type, Set domain_set)
        // for the (x, y) points
        pointsFf = new FlatField(indexFunc, indexSet);
        pointsFf.setSamples(getXY());

        ////////////////////////////////////////////////////////////////////////
        // Code for setting the single (recent) point display
        indexSet0 =  new Integer1DSet(index, 1);
        pointFf = new FlatField(indexFunc, indexSet0);
        pointFf.setSamples(getXY0());

        /**@todo Implement lines display as well as points*/

        ////////////////////////////////////////////////////////////////////////
        // Display code
        // Create Display and its maps

        // A 2D display
        display = new DisplayImplJ2D("display1");

        // Get display's graphics mode control and draw scales
        GraphicsModeControl dispGMC = (GraphicsModeControl) display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);

        // Create the ScalarMaps: quantity time is to be displayed along XAxis
        // and height along YAxis
        // Use ScalarMap(ScalarType scalar, DisplayRealType display_scalar)
        xMap = new ScalarMap(posX, Display.XAxis);
        yMap = new ScalarMap(posY, Display.YAxis);

        // We create a new ScalarMap, with time as RealType and SelectRange as DisplayRealType
        xRangeMap = new ScalarMap(posX, Display.SelectRange);

        // Add maps to display
        display.addMap(xMap);
        display.addMap(yMap);
        display.addMap(xRangeMap);

        // Scale yMap. This will scale the y-axis, because yMap has
        // DisplayRealType YAXIS. We simply choose the range from -20 to 20 for
        // the x-axis and -20.0 to 20.0 for
        xMap.setRange(-20.0, 20.0);
        yMap.setRange(-20.0, 20.0);

        // Select the range of RealType time
        RangeControl xRangeControl = (RangeControl) xRangeMap.getControl();
        float[] xRange = { -20.0f, 20.0f };
        xRangeControl.setRange(xRange);

        // Create a data reference and set the FlatField as our data
        pointsRef = new DataReferenceImpl("pointsRef");
        pointRef = new DataReferenceImpl("pointRef");
        //line_ref = new DataReferenceImpl("line_ref");

        pointsRef.setData(pointsFf);
        pointRef.setData(pointFf);
        //line_ref.setData( line_ff );

        // Define a ConstantMap to draw large red points
        ConstantMap[] pointsCMap = {     new ConstantMap( 1.0f, Display.Red),
                new ConstantMap( 0.0f, Display.Green),
                new ConstantMap( 0.0f, Display.Blue),
                new ConstantMap( 2.0f, Display.PointSize)};

        ConstantMap[] pointCMap = {       new ConstantMap( 0.0f, Display.Red),
                new ConstantMap( 0.8f, Display.Green),
                new ConstantMap( 0.0f, Display.Blue),
                new ConstantMap( 5.0f, Display.PointSize)};


        // Add reference to display, and link DataReference to ConstantMap
        display.addReference( pointRef , pointCMap);
        display.addReference( pointsRef, pointsCMap );


        // Create application window
        JFrame frame = new JFrame("VisAD " + this);
        frame.getContentPane().add(display.getComponent());
        frame.setSize(300, 300);
        frame.setVisible(true);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });

    }

    ////////////////////////////////////////////////////////////////////////////
    // Implement IPointListener
    /**
     * IMplementation for IPointListener
     */
    public void update(Point point) throws RemoteException {
        // Pop the new point in the top of the queue and drop the lastpoint
        for (int i = points.length - 1; i > 0; i--) {
            points[i] = points[i - 1];
        }
        points[0] = (Point) point.clone();

        // Update the data on the display
        try {
            pointsFf.setSamples(getXY());
            pointFf.setSamples(getXY0());
        } catch (VisADException e) {
            e.printStackTrace();
        }

    }

    /**
     * Return the data stored internally in the Points[] as a float[][] for use
     * by VisAd
     * @return A 2xpoints.length array. The first rown is the x data, the
     * second is the y data.
     */
    private float[][] getXY() {
        float[][] tmp = new float[2][points.length];
        for (int i = 0; i < points.length; i++) {
            if (points[i] != null) {
                tmp[0][i] = (float) points[i].getX();
                tmp[1][i] = (float) points[i].getY();
            } else {
                tmp[0][i] = 0F;
                tmp[1][i] = 0F;
            }
        }
        return tmp;
    }

    private float[][] getXY0() {
        float[][] tmp = new float[2][1];
        if (points[0] != null) {
            tmp[0][0] = (float) points[0].getX();
            tmp[1][0] = (float) points[0].getY();
        } else {
            tmp[0][0] = 0F;
            tmp[1][0] = 0F;
        }
        return tmp;
    }

    public static void main(String[] args) {
        try {
            RandomWalk rw = null;
            if (args.length == 0) {
                rw = new RandomWalk();
            } else {
                rw = new RandomWalk(Long.parseLong(args[0]));
            }
            PointVis2 pv = new PointVis2();
            rw.addPointListener(pv);
            rw.start();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    /** Store the positions to be displayed */
    private RealType index;
    private RealType posX;
    private RealType posY;

    private RealTupleType xyTuple;

    /**
     * The function ( x(i), y(i) ), where i = index,
     * represented by ( index -> ( x, y) )
     * ( x, y) are a Tuple, so we have a FunctionType
     * from index to a tuple
     */
    private FunctionType indexFunc;
    private FunctionType xyFunc;

    /**
     * Our Data values: the domain Set xySet for ( x -> y )
     * and the Set indexSet for the indexed points
     */
    private Set indexSet;
    private Set indexSet0;
    private Set xySet;

    /**
     * The Data class FlatField, which will hold time and height data.
     * time Data for line is implicitely given by the Set time_set
     * point_vals_ff holds the point values
     */
    private FlatField lineFf;
    private FlatField pointsFf; // For multipoint display
    private FlatField pointFf;  // For single point display

    /** The DataReference from the data to display */
    private DataReferenceImpl lineRef;
    private DataReferenceImpl pointsRef;
    private DataReferenceImpl pointRef;

    /** The 2D display, and its the maps */
    private DisplayImpl display;
    private ScalarMap xMap;
    private ScalarMap yMap;
    private ScalarMap xRangeMap;

    /**
     * The data is stored here. This is update by Through the IPointLIstener
     *  Interface. The most recent point is stored in points[0].
     */
    private Point[] points;

}