package org.mbari.swing.tree;

import java.io.File;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * <p>Represents a directory node in a tree</p><hr><br>
 *
 * <p>MBARI provides this documentation and code &quot;as is&quot;, with no
 * warranty, express or implied, of its quality or consistency. It is provided
 * without support and without obligation on the part of the Monterey Bay
 * Aquarium Research Institute to assist in its use, correction, modification,
 * or enhancement. This information should not be published or distributed to
 * third parties without specific written permission from MBARI.</p><br>
 *
 * Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.<br><hr><br>
 *
 * $Log: DirNode.java,v $
 * Revision 1.1.1.1  2002/07/02 22:07:12  brian
 * refresh import
 *
 * Revision 1.4  2002/01/30 00:23:56  brian
 * Added comments to all classes and methods. Tested the accuracy of AsciiRasterGridReader and AsciiRasterGridWriter. Also checked the the GridUtil was populating the spatial grids correctly and accurately. The data files generated matched up perfectly with the orginal text files. Also implemented an RovAltitudeFilter class to encapsulate different filtering methods.
 *<br><hr><br>
 *
 * @author  : $Author: brian $
 * @version : $Revision: 1.1.1.1 $
 */
public class DirNode extends FileSystemNode {


    public DirNode(File file) {
        super(file);
    }

    public void explore() {
        if (!isExplored()) {
            File file = getFile();
            File[] children = file.listFiles();
            Arrays.sort(children);
            for (int i = 0; i < children.length; i++) {
                if (children[i].isDirectory()) {
                    add(new DirNode(children[i]));
                }
            }
            explored = true;
        }
    }

}