package org.mbari.swing;

import java.awt.*;
import java.io.File;
import javax.swing.*;
import java.awt.event.*;

/**
 * <p>A standard widget used for browsing for files to save.</p><hr><br>
 *
 * <p>MBARI provides this documentation and code &quot;as is&quot;, with no
 * warranty, express or implied, of its quality or consistency. It is provided
 * without support and without obligation on the part of the Monterey Bay
 * Aquarium Research Institute to assist in its use, correction, modification,
 * or enhancement. This information should not be published or distributed to
 * third parties without specific written permission from MBARI.</p><br>
 *
 * Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.<br><hr><br>
 *
 * $Log: FileSavePanel1.java,v $
 * Revision 1.1.1.1  2002/07/02 22:07:12  brian
 * refresh import
 *
 * Revision 1.3  2002/01/30 00:23:56  brian
 * Added comments to all classes and methods. Tested the accuracy of AsciiRasterGridReader and AsciiRasterGridWriter. Also checked the the GridUtil was populating the spatial grids correctly and accurately. The data files generated matched up perfectly with the orginal text files. Also implemented an RovAltitudeFilter class to encapsulate different filtering methods.
 *<br><hr><br>
 *
 * @author  : $Author: brian $
 * @version : $Revision: 1.1.1.1 $
 */
public class FileSavePanel1 extends JPanel {
    JTextField tfFilename1 = new JTextField();
    JButton btnBrowse1 = new JButton();
    JFileChooser chooser;
    File file;

    public FileSavePanel1() {
        try {
            jbInit();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    void jbInit() throws Exception {
        tfFilename1.setPreferredSize(new Dimension(250, 19));
        tfFilename1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                tfFilename1_actionPerformed(e);
            }
        });
        btnBrowse1.setPreferredSize(new Dimension(47, 19));
        btnBrowse1.setToolTipText("Select a file");
        btnBrowse1.setText("Browse");
        btnBrowse1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnBrowse1_actionPerformed(e);
            }
        });
        this.add(tfFilename1, null);
        this.add(btnBrowse1, null);
    }

    void btnBrowse1_actionPerformed(ActionEvent e) {
        if (chooser == null) {
            chooser = new JFileChooser();
        }
        int state = chooser.showSaveDialog(this);
        if (state == JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            //this is where a real application would open the file.
            tfFilename1.setText(file.getAbsolutePath());
        }

    }

    /**
     * Return the chooser used for this component. This allows sharing of the chooser
     * in an application. The advantage to this (besides speed) is that the
     * chooser will remember the last directory selected between uses.
     * @return The fiel chooser hat is used by this component
     */
    public JFileChooser getChooser() {
        return chooser;
    }

    /**
     * Sets the chooser used by this component. This allows sharing of the chooser
     * in an application. The advantage to this (besides speed) is that the
     * chooser will remember the last directory selected between uses. If no
     * chooser is assigned before this component needs to use one, a chooser will
     * be created.
     * @param chooser The JFileChooser to be used by this component.
     */
    public void setChooser(JFileChooser chooser) {
        this.chooser = chooser;
    }

    /**
     * @return The file selected by this chooser
     */
    public File getFile() {
        file = new File(tfFilename1.getText());
        return file;
    }

    /**
     * @param Sets the file used by this chooser
     */
    public void setFile(File file) {
        this.file = file;
        tfFilename1.setText(file.getAbsolutePath());
    }

    void tfFilename1_actionPerformed(ActionEvent e) {
        file = new File(tfFilename1.getText());
    }
}