package org.mbari.swing;

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;

/**
 * <p>A frame containing a progress bar.</p><hr><br>
 *
 * <p>MBARI provides this documentation and code &quot;as is&quot;, with no
 * warranty, express or implied, of its quality or consistency. It is provided
 * without support and without obligation on the part of the Monterey Bay
 * Aquarium Research Institute to assist in its use, correction, modification,
 * or enhancement. This information should not be published or distributed to
 * third parties without specific written permission from MBARI.</p><br>
 *
 * Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.<br><hr><br>
 *
 * $Log: FileProgressFrame.java,v $
 * Revision 1.1.1.1  2002/07/02 22:07:12  brian
 * refresh import
 *
 * Revision 1.2  2002/01/30 00:23:56  brian
 * Added comments to all classes and methods. Tested the accuracy of AsciiRasterGridReader and AsciiRasterGridWriter. Also checked the the GridUtil was populating the spatial grids correctly and accurately. The data files generated matched up perfectly with the orginal text files. Also implemented an RovAltitudeFilter class to encapsulate different filtering methods.
 *<br><hr><br>
 *
 * @author  : $Author: brian $
 * @version : $Revision: 1.1.1.1 $
 */
public class FileProgressFrame extends JFrame {
    JProgressBar jProgressBar = new JProgressBar();
    Border border1;
    TitledBorder titledBorder1;
    public FileProgressFrame() {
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        border1 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
        titledBorder1 = new TitledBorder(border1,"Working ...");
        jProgressBar.setBorder(titledBorder1);
        jProgressBar.setPreferredSize(new Dimension(380, 45));
        this.getContentPane().add(jProgressBar, BorderLayout.CENTER);
        this.setSize(390, 55);
    }

    /**
     *
     * @return The progress bar associated with this component.
     */
    public javax.swing.JProgressBar getJProgressBar() {
        return jProgressBar;
    }

}