package org.mbari.swing;

import java.awt.*;
import java.io.File;
import javax.swing.*;
import org.mbari.awt.layout.VerticalFlowLayout;
import java.awt.event.*;

/**
 * <p>A standard widget for selecting multiple files.</p><hr><br>
 *
 * <p>MBARI provides this documentation and code &quot;as is&quot;, with no
 * warranty, express or implied, of its quality or consistency. It is provided
 * without support and without obligation on the part of the Monterey Bay
 * Aquarium Research Institute to assist in its use, correction, modification,
 * or enhancement. This information should not be published or distributed to
 * third parties without specific written permission from MBARI.</p><br>
 *
 * Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.<br><hr><br>
 *
 * $Log: FileListPanel1.java,v $
 * Revision 1.1.1.1  2002/07/02 22:07:12  brian
 * refresh import
 *
 * Revision 1.4  2002/07/02 21:08:34  brian
 * Minor modifications
 *
 * Revision 1.3  2002/01/30 00:23:56  brian
 * Added comments to all classes and methods. Tested the accuracy of AsciiRasterGridReader and AsciiRasterGridWriter. Also checked the the GridUtil was populating the spatial grids correctly and accurately. The data files generated matched up perfectly with the orginal text files. Also implemented an RovAltitudeFilter class to encapsulate different filtering methods.
 *<br><hr><br>
 *
 * @author  : $Author: brian $
 * @version : $Revision: 1.1.1.1 $
 */
public class FileListPanel1 extends JPanel {
    JList jList1 = new JList();
    JPanel jPanel1 = new JPanel();
    JButton btnAdd = new JButton();
    JButton btnRemove = new JButton();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JFileChooser chooser;

    public FileListPanel1() {
        try {
            jbInit();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    void jbInit() throws Exception {
        jList1.setPreferredSize(new Dimension(250, 95));
        jPanel1.setPreferredSize(new Dimension(90, 60));
        jPanel1.setToolTipText("");
        jPanel1.setLayout(verticalFlowLayout1);
        btnAdd.setToolTipText("");
        btnAdd.setText("Add");
        btnAdd.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                btnAdd_actionPerformed(e);
            }
        });
        btnRemove.setToolTipText("");
        btnRemove.setText("Remove ");
        this.add(jList1, null);
        this.add(jPanel1, null);
        jPanel1.add(btnAdd, null);
        jPanel1.add(btnRemove, null);
    }

    /**
     * Return the chooser used for this component. This allows sharing of the chooser
     * in an application. The advantage to this (besides speed) is that the
     * chooser will remember the last directory selected between uses.
     * @return The fiel chooser hat is used by this component
     */
    public JFileChooser getChooser() {
        return chooser;
    }

    /**
     * Sets the chooser used by this component. This allows sharing of the chooser
     * in an application. The advantage to this (besides speed) is that the
     * chooser will remember the last directory selected between uses. If no
     * chooser is assigned before this component needs to use one, a chooser will
     * be created.
     * @param chooser The JFileChooser to be used by this component.
     */
    public void setChooser(JFileChooser chooser) {
        this.chooser = chooser;
    }

    void btnAdd_actionPerformed(ActionEvent e) {

    }
}