package org.mbari.swing;

import java.io.File;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.EventObject;
import org.mbari.util.FileUtil;
import org.mbari.swing.tree.DirNode;

/**
 * <p>Creates a directory tree (folders only) of all roots and allows the user to
 * open and drill down through these directories</p><hr><br>
 *
 * <p>MBARI provides this documentation and code &quot;as is&quot;, with no
 * warranty, express or implied, of its quality or consistency. It is provided
 * without support and without obligation on the part of the Monterey Bay
 * Aquarium Research Institute to assist in its use, correction, modification,
 * or enhancement. This information should not be published or distributed to
 * third parties without specific written permission from MBARI.</p><br>
 *
 * Copyright 2002 MBARI.<br>
 * MBARI Proprietary Information. All rights reserved.<br><hr><br>
 *
 * $Log: DirectoryTree1.java,v $
 * Revision 1.1.1.1  2002/07/02 22:07:12  brian
 * refresh import
 *
 * Revision 1.6  2002/01/30 00:23:56  brian
 * Added comments to all classes and methods. Tested the accuracy of AsciiRasterGridReader and AsciiRasterGridWriter. Also checked the the GridUtil was populating the spatial grids correctly and accurately. The data files generated matched up perfectly with the orginal text files. Also implemented an RovAltitudeFilter class to encapsulate different filtering methods.
 *<br><hr><br>
 *
 * @author  : $Author: brian $
 * @version : $Revision: 1.1.1.1 $
 */
public class DirectoryTree1 extends JTree {

    /**
     * Defualt constructor. Shows all the root directories.
     */
    public DirectoryTree1() {
        super(getDefaultTreeModel());
        setRootVisible(false);
        setShowsRootHandles(true); // Hide the "Root" node
        listen();
    }

    /**
     * Evidently I can't just override JTree's getDefaultTreeModel. This version
     * creates a TreeModel using the root directories.
     * @see org.mbari.util.FileUtil
     */
    protected static TreeModel getDefaultTreeModel() {

        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root Directories");
        File[] roots = FileUtil.getDirRoots();
        for (int i = 0; i < roots.length; i++) {
            root.add(new DirNode(roots[i]));
        }
        return new DefaultTreeModel(root);

    }

    /**
     * Listen for expansion of a node (i.e opening a directory). If the directory
     * is opened add all child directories in it to the DirectoryTree1.
     */
    protected void listen() {
        addTreeExpansionListener(new TreeExpansionListener() {
            public void treeCollapsed(TreeExpansionEvent e) {

            }

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                DirNode node = (DirNode) path.getLastPathComponent();
                DefaultTreeModel model = null;
                if (!node.isExplored()) {
                    model = (DefaultTreeModel) getModel();
                    if (model != null) {
                        node.explore();
                        model.nodeStructureChanged(node);
                    }
                }

            }
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("DirectoryTree1 test");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e){
                System.exit(0);
            }
        });
        DirectoryTree1 tree = new DirectoryTree1();

        Container p = f.getContentPane();
        f.getContentPane().add(tree);

        f.setSize(300, 300);
        f.pack();
        f.setVisible(true);
        f.show();


    }

}