package org.mbari.oasis;

/**
 * Title:        MBARI Java development
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      MBARI
 * @author Brian Schlining
 * @version 1.0
 */

public class Pco2FileFormat {

    public Pco2FileFormat(int fileFormat) {
         this.fileFormat = fileFormat;
    }

    public int getMinNumColumns() {
         return COLUMNS[fileFormat].length + 2;
    }

    public int getMaxNumColumns() {
         return COLUMNS[fileFormat].length + 3;
    }

    public String[] getColumnNames() {
         return COLUMNS[fileFormat];
    }

    public String[] getUnits() {
         return UNITS[fileFormat];
    }

    public String[] getLongName() {
         return LONG_NAME[fileFormat];
    }

    // Column 1 is dayOfYear and the last column is year so COLUMNS specifies
    // the name of columns 2:end-1
    private String[][] COLUMNS = {
        {"pco2", "temp", "water"},
        {"pco2", "mv", "temp", "pressure"},
        {"mv", "pco2", "temp", "pressure"}
    };
    private String[][] UNITS = {
        {"parts per million", "degrees Celsius", "millivolts"},
        {"parts per million", "millivolts", "degrees Celsius", "kilopascals"},
        {"millivolts", "parts per million", "degrees Celsius", "millivolts"}
    };
    private String[][] LONG_NAME = {
        {"pCO2", "sensor internal temperature", "water sensor alarm"},
        {"pCO2", "sensor output voltage", "sensor internal temperature",
         "sensor internal pressure"},
        {"sensor output voltage", "pCO2", "sensor internal temperature",
         "sensor internal pressure"}
    };

    private int fileFormat;
    public static final int OLD_6_COLUMN = 0;
    public static final int NEW_7_COLUMN = 1;
    public static final int NEWER_7_COLUMN = 2;
}