package org.mbari.oasis;

import java.io.*;
import java.util.*;
import org.mbari.util.*;
import org.mbari.io.*;


/**
 * Checks files for duplicate data. If found it removes the lines containing
 * the duplicate data and writes the rest back to the file
 *
 * Its not very smart at this point. This program simple takes the first line
 * of data and looks for any lines that start with the first number of the
 * first line. If a duplicate is found it chops of the file from the duplicate
 * line to the end of the file
 */
public class OasisFileChecker {

   OasisFileChecker(File f) throws IOException {
      this.file = f;
      init();
      process();
   }

   OasisFileChecker(String f) throws IOException {
      this.file = new File(f);
      init();
      process();
   }

   /**
    * Setup variables
    */
   private void init() throws IOException {
      // Read the data file
      FlatFileReader ffr = new FlatFileReader(this.file);
      ffr.readFile();

      // Get the dates from the file
      this.dates  = new double[ffr.countRows()];
      for (int i = 0; i < this.dates.length; i++) {
         this.dates[i] = ffr.getData(i, 0);
      }

      this.process();
   }

   /**
    * call the processing methods
    *
    * @return index of the last data row in the file
    */
   private void process() {
      int i = checkDate();
      if (OK) {
         //Do nothing
      } else {
         try {
            this.rewrite(i);
         } catch (IOException e) {
            System.out.println("Unable to process " + this.file.getName());
         }
      }
   }

   /**
    * See if any lines of data are repeated in the file
    */
   private int checkDate() {
      double min = this.dates[0];
      int i = 1;
      loop: {
         while (i < this.dates.length) {
            if (min == this.dates[i]) {
               this.OK = false;
               break loop;
            }
            i++;
         }
      }

      // if all the dat points are OK return the index of the last data point
      return i;
   }

   private void rewrite(int i) throws IOException {
      System.out.println("OasisFileChecker: rewriting " + this.file);
      // Read the file
      BufferedReader in = new BufferedReader(new FileReader(this.file));
      String line;
      Vector text = new Vector(i);
      int lineCount = -1;
      int dataCount = 0;
      while ((line = in.readLine()) != null) {
         lineCount++;
         if (line.startsWith("#") || line.startsWith("%")) {
            text.add(lineCount, line);
         } else if (dataCount < i) {
            dataCount++;
            text.add(lineCount, line);

         }

      }
      in.close();


      // Write the file
      BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
      for (int j = 0; j < text.size(); j++) {
         out.write((String) text.elementAt(j));
         out.newLine();
      }
      out.close();
   }

   public static void main(String[] args) {

      if (args.length > 1 || args.length < 1) {
         System.out.println("Usage: OasisFileChecker filename/directory");
         System.exit(0);
      }

      File f = new File(args[0]);
      if (f.isDirectory()) {
         String[] list = f.list();
         for (int i = 0; i < list.length; i++) {
            try {
               OasisFileChecker oasisFileChecker = new OasisFileChecker(new File(f, list[i]));
            } catch (IOException e) {
               e.printStackTrace();
            }
         }
      } else {
         try {
            OasisFileChecker oasisFileChecker = new OasisFileChecker(f);
         } catch (IOException e) {
            e.printStackTrace();
         }
      }
      System.exit(1);
   }

   File file;
   double[] dates;
   boolean OK = true;
}