
/**
 * Title:        MBARI development package<p>
 * Description:  Default package environment<p>
 * Copyright:    Copyright (c) 1999<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version
 */
package org.mbari.oasis;

import java.util.*;
import java.io.*;
import java.text.*;

public class OasisExtractor {

   public OasisExtractor(String cfg_, String home_, int start_, int end_) {
      this.cfg = new File(cfg_);
      this.home = new File(home_);
      this.start = start_;
      this.end = end_;

   }

   public void start() {
      Runtime rt = Runtime.getRuntime();
      StringTokenizer st = new StringTokenizer(cfg.getName());
      String can = st.nextToken(".");
      String cfgP = this.cfg.getAbsolutePath();
      String filePath = this.home.getAbsolutePath();
      NumberFormat nf = NumberFormat.getInstance();
      nf.setMinimumIntegerDigits(2);
      nf.setMaximumIntegerDigits(2);
      nf.setMaximumFractionDigits(0);
      String hourS;
      for (int date = this.start; date <= this.end; date++) {
         for (int hour = 0; hour < 24; hour++) {
            hourS = nf.format((long) hour);
            System.out.println(can + "." + date + "." + hourS + ": ");
            try {
            rt.exec("nice /oasis/bin/extract -y 1 -i specprr -c " +
               cfgP +  " " + filePath + "/" + can + "." + date + "." + hourS);
            } catch (IOException e) {
               e.printStackTrace();
            }
         }
      }
   }

   public static void main(String[] args) {
      // use as: java OasisExtractor directory
      //         java OasisExtractor directory startDate endDate
      switch (args.length) {
         case 4:
            OasisExtractor oasisExtractor1 = new OasisExtractor(args[0], args[1],
               Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            oasisExtractor1.start();
            break;

         default:
            System.out.println("\n Use as:java OasisExtractor cfgFile directory startDate endDate");
      }
   }

   private File home,
                cfg;
   private String can;
   private int start, end;
}

/*set startdate = 96177
set endate    = 96299
set date      = $startdate
set can       = m1
set filepath = /oasis_tmp/brian/mooring/monterey/m1/raw

while($date < $endate)
    foreach file ($filepath/$can.$date.*)
		 echo $file
         nice /oasis/bin/extract -y 1 -i specprr -c /oasis_tmp/brian/mooring/monterey/cfg/$can.cfg $file
    end
    @ date ++
end*/